/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

class ReflectiveMethodExecutor
implements MethodExecutor {
    private final Method method;
    private final int[] argsRequiringConversion;

    public ReflectiveMethodExecutor(Method theMethod, int[] argumentsRequiringConversion) {
        this.method = theMethod;
        this.argsRequiringConversion = argumentsRequiringConversion;
    }

    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        try {
            if (this.argsRequiringConversion != null && arguments != null) {
                ReflectionHelper.convertArguments(this.method.getParameterTypes(), this.method.isVarArgs(), context.getTypeConverter(), this.argsRequiringConversion, arguments);
            }
            if (this.method.isVarArgs()) {
                arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.method.getParameterTypes(), arguments);
            }
            ReflectionUtils.makeAccessible(this.method);
            return new TypedValue(this.method.invoke(target, arguments), new TypeDescriptor(new MethodParameter(this.method, -1)));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking method: " + this.method, ex);
        }
    }
}

