/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.dao.ReflectionSaltSource;
import org.springframework.security.authentication.dao.SystemWideSaltSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class SaltSourceBeanDefinitionParser {
    private static final String ATT_USER_PROPERTY = "user-property";
    private static final String ATT_REF = "ref";
    private static final String ATT_SYSTEM_WIDE = "system-wide";

    SaltSourceBeanDefinitionParser() {
    }

    public BeanMetadataElement parse(Element element, ParserContext parserContext) {
        String ref = element.getAttribute(ATT_REF);
        if (StringUtils.hasText(ref)) {
            return new RuntimeBeanReference(ref);
        }
        String userProperty = element.getAttribute(ATT_USER_PROPERTY);
        if (StringUtils.hasText(userProperty)) {
            RootBeanDefinition saltSource = new RootBeanDefinition(ReflectionSaltSource.class);
            saltSource.getPropertyValues().addPropertyValue("userPropertyToUse", userProperty);
            saltSource.setSource(parserContext.extractSource(element));
            saltSource.setRole(2);
            return saltSource;
        }
        String systemWideSalt = element.getAttribute(ATT_SYSTEM_WIDE);
        if (StringUtils.hasText(systemWideSalt)) {
            RootBeanDefinition saltSource = new RootBeanDefinition(SystemWideSaltSource.class);
            saltSource.getPropertyValues().addPropertyValue("systemWideSalt", systemWideSalt);
            saltSource.setSource(parserContext.extractSource(element));
            saltSource.setRole(2);
            return saltSource;
        }
        parserContext.getReaderContext().error("salt-source requires an attribute", element);
        return null;
    }
}

