/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.SessionManagementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilterChainValidator
implements FilterChainProxy.FilterChainValidator {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void validate(FilterChainProxy fcp) {
        Map<String, List<Filter>> filterChainMap = fcp.getFilterChainMap();
        for (String pattern : fcp.getFilterChainMap().keySet()) {
            List<Filter> filters = filterChainMap.get(pattern);
            this.checkFilterStack(filters);
        }
        this.checkLoginPageIsntProtected(fcp, filterChainMap.get(fcp.getMatcher().getUniversalMatchPattern()));
    }

    private Object getFilter(Class<?> type, List<Filter> filters) {
        for (Filter f : filters) {
            if (!type.isAssignableFrom(f.getClass())) continue;
            return f;
        }
        return null;
    }

    private void checkFilterStack(List<Filter> filters) {
        this.checkForDuplicates(SecurityContextPersistenceFilter.class, filters);
        this.checkForDuplicates(UsernamePasswordAuthenticationFilter.class, filters);
        this.checkForDuplicates(SessionManagementFilter.class, filters);
        this.checkForDuplicates(BasicAuthenticationFilter.class, filters);
        this.checkForDuplicates(SecurityContextHolderAwareRequestFilter.class, filters);
        this.checkForDuplicates(ExceptionTranslationFilter.class, filters);
        this.checkForDuplicates(FilterSecurityInterceptor.class, filters);
    }

    private void checkForDuplicates(Class<? extends Filter> clazz, List<Filter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter f1 = filters.get(i);
            if (!clazz.isAssignableFrom(f1.getClass())) continue;
            for (int j = i + 1; j < filters.size(); ++j) {
                Filter f2 = filters.get(j);
                if (!clazz.isAssignableFrom(f2.getClass())) continue;
                this.logger.warn("Possible error: Filters at position " + i + " and " + j + " are both " + "instances of " + clazz.getName());
                return;
            }
        }
    }

    private void checkLoginPageIsntProtected(FilterChainProxy fcp, List<Filter> defaultFilters) {
        ExceptionTranslationFilter etf = (ExceptionTranslationFilter)this.getFilter(ExceptionTranslationFilter.class, defaultFilters);
        if (etf.getAuthenticationEntryPoint() instanceof LoginUrlAuthenticationEntryPoint) {
            String loginPage = ((LoginUrlAuthenticationEntryPoint)etf.getAuthenticationEntryPoint()).getLoginFormUrl();
            List<Filter> filters = fcp.getFilters(loginPage);
            this.logger.info("Checking whether login URL '" + loginPage + "' is accessible with your configuration");
            if (filters == null || filters.isEmpty()) {
                this.logger.debug("Filter chain is empty for the login page");
                return;
            }
            if (this.getFilter(DefaultLoginPageGeneratingFilter.class, filters) != null) {
                this.logger.debug("Default generated login page is in use");
                return;
            }
            FilterSecurityInterceptor fsi = (FilterSecurityInterceptor)this.getFilter(FilterSecurityInterceptor.class, filters);
            DefaultFilterInvocationSecurityMetadataSource fids = (DefaultFilterInvocationSecurityMetadataSource)fsi.getSecurityMetadataSource();
            Collection<ConfigAttribute> attributes = fids.lookupAttributes(loginPage, "POST");
            if (attributes == null) {
                this.logger.debug("No access attributes defined for login page URL");
                if (fsi.isRejectPublicInvocations()) {
                    this.logger.warn("FilterSecurityInterceptor is configured to reject public invocations. Your login page may not be accessible.");
                }
                return;
            }
            AnonymousAuthenticationFilter anonPF = (AnonymousAuthenticationFilter)this.getFilter(AnonymousAuthenticationFilter.class, filters);
            if (anonPF == null) {
                this.logger.warn("The login page is being protected by the filter chain, but you don't appear to have anonymous authentication enabled. This is almost certainly an error.");
                return;
            }
            AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", (Object)anonPF.getUserAttribute().getPassword(), anonPF.getUserAttribute().getAuthorities());
            try {
                fsi.getAccessDecisionManager().decide(token, new Object(), fids.lookupAttributes(loginPage, "POST"));
            }
            catch (Exception e) {
                this.logger.warn("Anonymous access to the login page doesn't appear to be enabled. This is almost certainly an error. Please check your configuration allows unauthenticated access to the configured login page. (Simulated access was rejected: " + e + ")");
            }
        }
    }
}

