/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ContextPropagatingRemoteInvocation
extends RemoteInvocation {
    private static final Log logger = LogFactory.getLog(ContextPropagatingRemoteInvocation.class);
    private SecurityContext securityContext = SecurityContextHolder.getContext();

    public ContextPropagatingRemoteInvocation(MethodInvocation methodInvocation) {
        super(methodInvocation);
        if (logger.isDebugEnabled()) {
            logger.debug("RemoteInvocation now has SecurityContext: " + this.securityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SecurityContextHolder.setContext(this.securityContext);
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            SecurityContextHolder.getContext().getAuthentication().setAuthenticated(false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Set SecurityContextHolder to contain: " + this.securityContext);
        }
        try {
            Object object = super.invoke(targetObject);
            return object;
        }
        finally {
            SecurityContextHolder.clearContext();
            if (logger.isDebugEnabled()) {
                logger.debug("Cleared SecurityContextHolder.");
            }
        }
    }
}

