/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.Field;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    private FieldUtils() {
    }

    public static String getAccessorName(String fieldName, Class<?> type) {
        Assert.hasText(fieldName, "FieldName required");
        Assert.notNull(type, "Type required");
        if (type.getName().equals("boolean")) {
            return "is" + StringUtils.capitalize(fieldName);
        }
        return "get" + StringUtils.capitalize(fieldName);
    }

    public static Field getField(Class<?> clazz, String fieldName) throws IllegalStateException {
        Assert.notNull(clazz, "Class required");
        Assert.hasText(fieldName, "Field name required");
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsf) {
            if (clazz.getSuperclass() != null) {
                return FieldUtils.getField(clazz.getSuperclass(), fieldName);
            }
            throw new IllegalStateException("Could not locate field '" + fieldName + "' on class " + clazz);
        }
    }

    public static Object getFieldValue(Object bean, String fieldName) throws IllegalAccessException {
        Assert.notNull(bean, "Bean cannot be null");
        Assert.hasText(fieldName, "Field name required");
        String[] nestedFields = StringUtils.tokenizeToStringArray(fieldName, ".");
        Class<?> componentClass = bean.getClass();
        Field field = null;
        Object value = bean;
        for (int i = 0; i < nestedFields.length; ++i) {
            field = FieldUtils.getField(componentClass, nestedFields[i]);
            field.setAccessible(true);
            value = field.get(value);
            if (value == null) continue;
            componentClass = value.getClass();
        }
        return value;
    }

    public static String getMutatorName(String fieldName) {
        Assert.hasText(fieldName, "FieldName required");
        return "set" + StringUtils.capitalize(fieldName);
    }

    public static Object getProtectedFieldValue(String protectedField, Object object) {
        Field field = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            return null;
        }
    }

    public static void setProtectedFieldValue(String protectedField, Object object, Object newValue) {
        Field field = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field.setAccessible(true);
            field.set(object, newValue);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }
}

