/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.DummyRequest;
import org.springframework.security.web.access.DummyResponse;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;

public class DefaultWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator {
    protected static final Log logger = LogFactory.getLog(DefaultWebInvocationPrivilegeEvaluator.class);
    static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            throw new UnsupportedOperationException("DefaultWebInvocationPrivilegeEvaluator does not support filter chains");
        }
    };
    static final HttpServletResponse DUMMY_RESPONSE = new DummyResponse();
    private AbstractSecurityInterceptor securityInterceptor;

    public DefaultWebInvocationPrivilegeEvaluator(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull(securityInterceptor, "SecurityInterceptor cannot be null");
        Assert.isTrue(FilterInvocation.class.equals(securityInterceptor.getSecureObjectClass()), "AbstractSecurityInterceptor does not support FilterInvocations");
        Assert.notNull(securityInterceptor.getAccessDecisionManager(), "AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    public boolean isAllowed(String uri, Authentication authentication) {
        return this.isAllowed(null, uri, null, authentication);
    }

    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        Assert.notNull(uri, "uri parameter is required");
        if (contextPath == null) {
            contextPath = "/ctxpath";
        }
        FilterInvocation fi = this.createFilterInvocation(contextPath, uri, method);
        Collection<ConfigAttribute> attrs = this.securityInterceptor.obtainSecurityMetadataSource().getAttributes(fi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, fi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug(fi.toString() + " denied for " + authentication.toString(), unauthorized);
            }
            return false;
        }
        return true;
    }

    private FilterInvocation createFilterInvocation(String contextPath, String uri, String method) {
        Assert.hasText(uri, "URI required");
        DummyRequest req = new DummyRequest();
        req.setRequestURI(contextPath + uri);
        req.setContextPath(contextPath);
        req.setServletPath(null);
        req.setMethod(method);
        return new FilterInvocation(req, DUMMY_RESPONSE, DUMMY_CHAIN);
    }
}

