/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.UrlMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final Set<String> HTTP_METHODS = new HashSet<String>(Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Map<Object, Collection<ConfigAttribute>>> httpMethodMap = new HashMap<String, Map<Object, Collection<ConfigAttribute>>>();
    private UrlMatcher urlMatcher;
    private boolean stripQueryStringFromUrls;

    public DefaultFilterInvocationSecurityMetadataSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap) {
        this.urlMatcher = urlMatcher;
        for (Map.Entry<RequestKey, Collection<ConfigAttribute>> entry : requestMap.entrySet()) {
            this.addSecureUrl(entry.getKey().getUrl(), entry.getKey().getMethod(), entry.getValue());
        }
    }

    private void addSecureUrl(String pattern, String method, Collection<ConfigAttribute> attrs) {
        Map<Object, Collection<ConfigAttribute>> mapToUse = this.getRequestMapForHttpMethod(method);
        mapToUse.put(this.urlMatcher.compile(pattern), attrs);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added URL pattern: " + pattern + "; attributes: " + attrs + (method == null ? "" : " for HTTP method '" + method + "'"));
        }
    }

    private Map<Object, Collection<ConfigAttribute>> getRequestMapForHttpMethod(String method) {
        if (method != null && !HTTP_METHODS.contains(method)) {
            throw new IllegalArgumentException("Unrecognised HTTP method: '" + method + "'");
        }
        Map<Object, Collection<ConfigAttribute>> methodRequestMap = this.httpMethodMap.get(method);
        if (methodRequestMap == null) {
            methodRequestMap = new LinkedHashMap<Object, Collection<ConfigAttribute>>();
            this.httpMethodMap.put(method, methodRequestMap);
        }
        return methodRequestMap;
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> allAttributes = new HashSet<ConfigAttribute>();
        for (Map.Entry<String, Map<Object, Collection<ConfigAttribute>>> entry : this.httpMethodMap.entrySet()) {
            for (Collection<ConfigAttribute> attrs : entry.getValue().values()) {
                allAttributes.addAll(attrs);
            }
        }
        return allAttributes;
    }

    @Override
    public Collection<ConfigAttribute> getAttributes(Object object) {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    public final Collection<ConfigAttribute> lookupAttributes(String url, String method) {
        Collection<ConfigAttribute> attributes;
        int firstQuestionMarkIndex;
        if (this.stripQueryStringFromUrls && (firstQuestionMarkIndex = url.indexOf("?")) != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.urlMatcher.requiresLowerCaseUrl()) {
            url = url.toLowerCase();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'");
            }
        }
        if ((attributes = this.extractMatchingAttributes(url, this.httpMethodMap.get(method))) == null) {
            attributes = this.extractMatchingAttributes(url, this.httpMethodMap.get(null));
        }
        return attributes;
    }

    private Collection<ConfigAttribute> extractMatchingAttributes(String url, Map<Object, Collection<ConfigAttribute>> map) {
        if (map == null) {
            return null;
        }
        boolean debug = this.logger.isDebugEnabled();
        for (Map.Entry<Object, Collection<ConfigAttribute>> entry : map.entrySet()) {
            Object p = entry.getKey();
            boolean matched = this.urlMatcher.pathMatchesUrl(entry.getKey(), url);
            if (debug) {
                this.logger.debug("Candidate is: '" + url + "'; pattern is " + p + "; matched=" + matched);
            }
            if (!matched) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    protected UrlMatcher getUrlMatcher() {
        return this.urlMatcher;
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.urlMatcher.requiresLowerCaseUrl();
    }

    public void setStripQueryStringFromUrls(boolean stripQueryStringFromUrls) {
        this.stripQueryStringFromUrls = stripQueryStringFromUrls;
    }
}

