/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.j2ee;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationDetailsSourceImpl;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.MutableGrantedAuthoritiesContainer;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreAuthenticatedAuthenticationDetailsSource
extends AuthenticationDetailsSourceImpl {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Set<String> j2eeMappableRoles;
    protected Attributes2GrantedAuthoritiesMapper j2eeUserRoles2GrantedAuthoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.j2eeMappableRoles, "No mappable roles available");
        Assert.notNull(this.j2eeUserRoles2GrantedAuthoritiesMapper, "Roles to granted authorities mapper not set");
    }

    @Override
    public Object buildDetails(Object context) {
        Object result = super.buildDetails(context);
        if (result instanceof MutableGrantedAuthoritiesContainer) {
            Collection<String> j2eeUserRoles = this.getUserRoles(context, this.j2eeMappableRoles);
            List<GrantedAuthority> userGas = this.j2eeUserRoles2GrantedAuthoritiesMapper.getGrantedAuthorities(j2eeUserRoles);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("J2EE roles [" + j2eeUserRoles + "] mapped to Granted Authorities: [" + userGas + "]");
            }
            ((MutableGrantedAuthoritiesContainer)result).setGrantedAuthorities(userGas);
        }
        return result;
    }

    protected abstract Collection<String> getUserRoles(Object var1, Set<String> var2);

    public void setMappableRolesRetriever(MappableAttributesRetriever aJ2eeMappableRolesRetriever) {
        this.j2eeMappableRoles = aJ2eeMappableRolesRetriever.getMappableAttributes();
    }

    public void setUserRoles2GrantedAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper mapper) {
        this.j2eeUserRoles2GrantedAuthoritiesMapper = mapper;
    }
}

