/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class BeanPropertyBindingResult
extends AbstractPropertyBindingResult
implements Serializable {
    private final Object target;
    private final boolean autoGrowNestedPaths;
    private transient BeanWrapper beanWrapper;

    public BeanPropertyBindingResult(Object target, String objectName) {
        this(target, objectName, true);
    }

    public BeanPropertyBindingResult(Object target, String objectName, boolean autoGrowNestedPaths) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.beanWrapper == null) {
            this.beanWrapper = this.createBeanWrapper();
            this.beanWrapper.setExtractOldValueForEditor(true);
            this.beanWrapper.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        }
        return this.beanWrapper;
    }

    protected BeanWrapper createBeanWrapper() {
        Assert.state(this.target != null, "Cannot access properties on null bean instance '" + this.getObjectName() + "'!");
        return PropertyAccessorFactory.forBeanPropertyAccess(this.target);
    }
}

