/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.i18n.AbstractLocaleResolver;
import org.springframework.web.util.WebUtils;

public class SessionLocaleResolver
extends AbstractLocaleResolver {
    public static final String LOCALE_SESSION_ATTRIBUTE_NAME = String.valueOf(SessionLocaleResolver.class.getName()) + ".LOCALE";

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)WebUtils.getSessionAttribute(request, LOCALE_SESSION_ATTRIBUTE_NAME);
        if (locale == null) {
            locale = this.determineDefaultLocale(request);
        }
        return locale;
    }

    protected Locale determineDefaultLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = request.getLocale();
        }
        return defaultLocale;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        WebUtils.setSessionAttribute(request, LOCALE_SESSION_ATTRIBUTE_NAME, locale);
    }
}

