/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ServletWrappingController
extends AbstractController
implements BeanNameAware,
InitializingBean,
DisposableBean {
    private Class servletClass;
    private String servletName;
    private Properties initParameters = new Properties();
    private String beanName;
    private Servlet servletInstance;

    public void setServletClass(Class servletClass) {
        this.servletClass = servletClass;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setInitParameters(Properties initParameters) {
        this.initParameters = initParameters;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.servletClass == null) {
            throw new IllegalArgumentException("servletClass is required");
        }
        if (!Servlet.class.isAssignableFrom(this.servletClass)) {
            throw new IllegalArgumentException("servletClass [" + this.servletClass.getName() + "] needs to implement interface [javax.servlet.Servlet]");
        }
        if (this.servletName == null) {
            this.servletName = this.beanName;
        }
        this.servletInstance = (Servlet)this.servletClass.newInstance();
        this.servletInstance.init(new DelegatingServletConfig());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servletInstance.service(request, response);
        return null;
    }

    public void destroy() {
        this.servletInstance.destroy();
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return ServletWrappingController.this.servletName;
        }

        public ServletContext getServletContext() {
            return ServletWrappingController.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return ServletWrappingController.this.initParameters.getProperty(paramName);
        }

        public Enumeration getInitParameterNames() {
            return ServletWrappingController.this.initParameters.keys();
        }
    }
}

