/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private static final Log logger = LogFactory.getLog(ContentNegotiatingViewResolver.class);
    private static final String ACCEPT_HEADER = "Accept";
    private static final boolean jafPresent = ClassUtils.isPresent("javax.activation.FileTypeMap", ContentNegotiatingViewResolver.class.getClassLoader());
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private int order = Integer.MIN_VALUE;
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private String parameterName = "format";
    private boolean useNotAcceptableStatusCode = false;
    private boolean ignoreAcceptHeader = false;
    private boolean useJaf = true;
    private ConcurrentMap<String, MediaType> mediaTypes = new ConcurrentHashMap<String, MediaType>();
    private List<View> defaultViews;
    private MediaType defaultContentType;
    private List<ViewResolver> viewResolvers;
    private static final View NOT_ACCEPTABLE_VIEW = new View(){

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setStatus(406);
        }
    };

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    public void setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public void setMediaTypes(Map<String, String> mediaTypes) {
        Assert.notNull(mediaTypes, "'mediaTypes' must not be null");
        for (Map.Entry<String, String> entry : mediaTypes.entrySet()) {
            String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
            MediaType mediaType = MediaType.parseMediaType(entry.getValue());
            this.mediaTypes.put(extension, mediaType);
        }
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) {
        if (this.viewResolvers == null) {
            Map<String, ViewResolver> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.getApplicationContext(), ViewResolver.class);
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans.values()) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        }
        if (this.viewResolvers.isEmpty()) {
            logger.warn("Did not find any ViewResolvers to delegate to; please configure them using the 'viewResolvers' property on the ContentNegotiatingViewResolver");
        }
        OrderComparator.sort(this.viewResolvers);
    }

    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        String acceptHeader;
        String parameterValue;
        MediaType mediaType;
        String requestUri;
        String filename;
        MediaType mediaType2;
        if (this.favorPathExtension && (mediaType2 = this.getMediaTypeFromFilename(filename = WebUtils.extractFullFilenameFromUrlPath(requestUri = urlPathHelper.getRequestUri(request)))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested media type is '" + mediaType2 + "' (based on filename '" + filename + "')");
            }
            return Collections.singletonList(mediaType2);
        }
        if (this.favorParameter && request.getParameter(this.parameterName) != null && (mediaType = this.getMediaTypeFromParameter(parameterValue = request.getParameter(this.parameterName))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested media type is '" + mediaType + "' (based on parameter '" + this.parameterName + "'='" + parameterValue + "')");
            }
            return Collections.singletonList(mediaType);
        }
        if (!this.ignoreAcceptHeader && StringUtils.hasText(acceptHeader = request.getHeader(ACCEPT_HEADER))) {
            List<MediaType> mediaTypes = MediaType.parseMediaTypes(acceptHeader);
            MediaType.sortByQualityValue(mediaTypes);
            if (logger.isDebugEnabled()) {
                logger.debug("Requested media types are " + mediaTypes + " (based on Accept header)");
            }
            return mediaTypes;
        }
        if (this.defaultContentType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requested media types is " + this.defaultContentType + " (based on defaultContentType property)");
            }
            return Collections.singletonList(this.defaultContentType);
        }
        return Collections.emptyList();
    }

    protected MediaType getMediaTypeFromFilename(String filename) {
        String extension = StringUtils.getFilenameExtension(filename);
        if (!StringUtils.hasText(extension)) {
            return null;
        }
        MediaType mediaType = (MediaType)this.mediaTypes.get(extension = extension.toLowerCase(Locale.ENGLISH));
        if (mediaType == null && this.useJaf && jafPresent && (mediaType = ActivationMediaTypeFactory.getMediaType(filename)) != null) {
            this.mediaTypes.putIfAbsent(extension, mediaType);
        }
        return mediaType;
    }

    protected MediaType getMediaTypeFromParameter(String parameterValue) {
        return (MediaType)this.mediaTypes.get(parameterValue.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.isInstanceOf(ServletRequestAttributes.class, attrs);
        List<MediaType> requestedMediaTypes = this.getMediaTypes(((ServletRequestAttributes)attrs).getRequest());
        List<View> candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes);
        View bestView = this.getBestView(candidateViews, requestedMediaTypes);
        if (bestView != null) {
            return bestView;
        }
        if (this.useNotAcceptableStatusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug("No acceptable view found; returning 406 (Not Acceptable) status code");
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No acceptable view found; returning null");
        }
        return null;
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view != null) {
                candidateViews.add(view);
            }
            for (MediaType requestedMediaType : requestedMediaTypes) {
                List<String> extensions = this.getExtensionsForMediaType(requestedMediaType);
                for (String extension : extensions) {
                    String viewNameWithExtension = String.valueOf(viewName) + "." + extension;
                    view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                    if (view == null) continue;
                    candidateViews.add(view);
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    private List<String> getExtensionsForMediaType(MediaType requestedMediaType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.mediaTypes.entrySet()) {
            if (!requestedMediaType.includes((MediaType)entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes) {
        MediaType bestRequestedMediaType = null;
        View bestView = null;
        for (MediaType requestedMediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText(candidateView.getContentType()) || !requestedMediaType.includes(candidateContentType = MediaType.parseMediaType(candidateView.getContentType()))) continue;
                bestRequestedMediaType = requestedMediaType;
                bestView = candidateView;
                break;
            }
            if (bestView == null) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug("Returning [" + bestView + "] based on requested media type '" + bestRequestedMediaType + "'");
            break;
        }
        return bestView;
    }

    static /* synthetic */ Log access$0() {
        return logger;
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * Unable to fully structure code
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                block15: {
                    if (ContentNegotiatingViewResolver.access$0().isTraceEnabled()) {
                        ContentNegotiatingViewResolver.access$0().trace("Loading Java Activation Framework FileTypeMap from " + mappingLocation);
                    }
                    inputStream = null;
                    inputStream = mappingLocation.getInputStream();
                    var3_2 = new MimetypesFileTypeMap(inputStream);
                    if (inputStream == null) break block15;
                    try {
                        inputStream.close();
                    }
                    catch (IOException v0) {}
                }
                return var3_2;
                catch (IOException v1) {
                    try {
                        ** if (inputStream == null) goto lbl-1000
                    }
                    catch (Throwable var2_3) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v3) {}
                        }
                        throw var2_3;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v2) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            if (ContentNegotiatingViewResolver.access$0().isTraceEnabled()) {
                ContentNegotiatingViewResolver.access$0().trace("Loading default Java Activation Framework FileTypeMap");
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String fileName) {
            String mediaType = fileTypeMap.getContentType(fileName);
            return StringUtils.hasText(mediaType) ? MediaType.parseMediaType(mediaType) : null;
        }
    }
}

