/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.springframework.beans.BeansException;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.view.AbstractView;

public class MarshallingView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private Marshaller marshaller;
    private String modelKey;

    public MarshallingView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
    }

    public MarshallingView(Marshaller marshaller) {
        Assert.notNull(marshaller, "'marshaller' must not be null");
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.marshaller = marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull(marshaller, "'marshaller' must not be null");
        this.marshaller = marshaller;
    }

    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }

    protected void initApplicationContext() throws BeansException {
        Assert.notNull(this.marshaller, "Property 'marshaller' is required");
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object toBeMarshalled = this.locateToBeMarshalled(model);
        if (toBeMarshalled == null) {
            throw new ServletException("Unable to locate object to be marshalled in model: " + model);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        this.marshaller.marshal(toBeMarshalled, (Result)new StreamResult(bos));
        response.setContentType(this.getContentType());
        response.setContentLength(bos.size());
        FileCopyUtils.copy(bos.toByteArray(), (OutputStream)response.getOutputStream());
    }

    protected Object locateToBeMarshalled(Map model) throws ServletException {
        if (this.modelKey != null) {
            Object o = model.get(this.modelKey);
            if (o == null) {
                throw new ServletException("Model contains no object with key [" + this.modelKey + "]");
            }
            if (!this.marshaller.supports(o.getClass())) {
                throw new ServletException("Model object [" + o + "] retrieved via key [" + this.modelKey + "] is not supported by the Marshaller");
            }
            return o;
        }
        for (Object o : model.values()) {
            if (o == null || !this.marshaller.supports(o.getClass())) continue;
            return o;
        }
        return null;
    }
}

