/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import org.springframework.util.Assert;

public abstract class ExpressionEvaluationUtils {
    public static final String EXPRESSION_PREFIX = "${";
    public static final String EXPRESSION_SUFFIX = "}";

    public static boolean isExpressionLanguage(String value) {
        return value != null && value.contains(EXPRESSION_PREFIX);
    }

    public static Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, resultClass, pageContext);
        }
        if (attrValue != null && resultClass != null && !resultClass.isInstance(attrValue)) {
            throw new JspException("Attribute value \"" + attrValue + "\" is neither a JSP EL expression nor " + "assignable to result class [" + resultClass.getName() + "]");
        }
        return attrValue;
    }

    public static Object evaluate(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Object.class, pageContext);
        }
        return attrValue;
    }

    public static String evaluateString(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (String)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, String.class, pageContext);
        }
        return attrValue;
    }

    public static int evaluateInteger(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Integer)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Integer.class, pageContext);
        }
        return Integer.parseInt(attrValue);
    }

    public static boolean evaluateBoolean(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Boolean)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Boolean.class, pageContext);
        }
        return Boolean.valueOf(attrValue);
    }

    private static Object doEvaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        Assert.notNull(attrValue, "Attribute value must not be null");
        Assert.notNull(resultClass, "Result class must not be null");
        Assert.notNull(pageContext, "PageContext must not be null");
        try {
            if (resultClass.isAssignableFrom(String.class)) {
                int exprPrefixIndex;
                StringBuilder resultValue = null;
                int exprSuffixIndex = 0;
                do {
                    if ((exprPrefixIndex = attrValue.indexOf(EXPRESSION_PREFIX, exprSuffixIndex)) != -1) {
                        int prevExprSuffixIndex = exprSuffixIndex;
                        exprSuffixIndex = attrValue.indexOf(EXPRESSION_SUFFIX, exprPrefixIndex + EXPRESSION_PREFIX.length());
                        String expr = exprSuffixIndex != -1 ? attrValue.substring(exprPrefixIndex, exprSuffixIndex += EXPRESSION_SUFFIX.length()) : attrValue.substring(exprPrefixIndex);
                        if (expr.length() == attrValue.length()) {
                            return ExpressionEvaluationUtils.evaluateExpression(attrValue, resultClass, pageContext);
                        }
                        if (resultValue == null) {
                            resultValue = new StringBuilder();
                        }
                        resultValue.append(attrValue.substring(prevExprSuffixIndex, exprPrefixIndex));
                        resultValue.append(ExpressionEvaluationUtils.evaluateExpression(expr, String.class, pageContext));
                        continue;
                    }
                    if (resultValue == null) {
                        resultValue = new StringBuilder();
                    }
                    resultValue.append(attrValue.substring(exprSuffixIndex));
                } while (exprPrefixIndex != -1 && exprSuffixIndex != -1);
                return resultValue.toString();
            }
            return ExpressionEvaluationUtils.evaluateExpression(attrValue, resultClass, pageContext);
        }
        catch (ELException ex) {
            throw new JspException("Parsing of JSP EL expression failed for attribute '" + attrName + "'", (Throwable)ex);
        }
    }

    private static Object evaluateExpression(String exprValue, Class resultClass, PageContext pageContext) throws ELException {
        return pageContext.getExpressionEvaluator().evaluate(exprValue, resultClass, pageContext.getVariableResolver(), null);
    }
}

