/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatContextFileUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatDataSource;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;

public class CreateTomcatDataSourceStep
extends TomcatStepBase {
    private TomcatDataSource dataSource;

    public CreateTomcatDataSourceStep(TomcatUnmanagedServer server, TomcatDataSource dataSource, TomcatWarMapping mapping) {
        super(server, mapping);
        this.dataSource = dataSource;
        this.setDescription("Create datasource " + (Object)((Object)dataSource) + " on Tomcat server " + (Object)((Object)server) + " on context " + this.contextRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            HostFile dsFile = s.getFile(this.getContextFilePathOnServer());
            ctx.logOutput("Creating datasource definition in context file " + dsFile.getPath() + " on " + this.server.getHost());
            TomcatContextFileUtils contextFileUtils = new TomcatContextFileUtils(dsFile);
            contextFileUtils.addOrUpdateDataSource(this.dataSource);
            ctx.logOutput("Done.");
            boolean bl = true;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

