/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.Archetype;
import com.xebialabs.deployit.core.api.dto.Artifact;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="factory")
@ClassHelp(description="Helper that can construct archetypes, CIs and artifacts")
public class ObjectFactory
extends DocumentedObject {
    private DescriptorHelper descriptors;
    private static final Logger logger = LoggerFactory.getLogger(ObjectFactory.class);

    public ObjectFactory() {
    }

    public ObjectFactory(Proxies proxies) {
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Construct a CI of a specified type", parameters={@ParameterHelp(name="ciType", description="The (shortname) type of the CI")})
    public ConfigurationItem configurationItem(String ciType) {
        return this.configurationItem(ciType, Maps.<String, Object>newHashMap());
    }

    @MethodHelp(description="Construct a CI of a specified type with specified values", parameters={@ParameterHelp(name="ciType", description="The (shortname) type of the CI"), @ParameterHelp(name="values", description="The values of the CI in a map.")})
    public ConfigurationItem configurationItem(String ciType, Map<String, Object> values) {
        if (!this.checkSimpleNameMap(ciType)) {
            return null;
        }
        String type = this.descriptors.getRegisteredType(ciType);
        ConfigurationItem configurationItem = new ConfigurationItem(type);
        configurationItem.setValues(Maps.newHashMap(values));
        return configurationItem;
    }

    @MethodHelp(description="Construct an  archetype for a CI of a specified type", parameters={@ParameterHelp(name="ciType", description="The (shortname) type of the CI")})
    public Archetype archetype(String ciType) {
        return this.archetype(ciType, Maps.<String, Object>newHashMap());
    }

    @MethodHelp(description="Construct an  archetype for a CI of a specified type with specified base values", parameters={@ParameterHelp(name="ciType", description="The (shortname) type that CIs based on this archetype will be"), @ParameterHelp(name="values", description="The base values for the archetype in a map.")})
    public Archetype archetype(String ciType, Map<String, Object> values) {
        if (!this.checkSimpleNameMap(ciType)) {
            return null;
        }
        String type = this.descriptors.getRegisteredType(ciType);
        Archetype archetype = new Archetype(type);
        archetype.setValues(Maps.newHashMap(values));
        return archetype;
    }

    @MethodHelp(description="Construct an artifact of a specific type with associated data", parameters={@ParameterHelp(name="ciType", description="The (shortname) type of this artifact"), @ParameterHelp(name="values", description="The values for this artifact in a map."), @ParameterHelp(name="data", description="The data of this artifact that is to be uploaded")}, returns="An Artifact with data that can be stored in Deployit.")
    public ArtifactAndData artifact(String ciType, Map<String, Object> values, byte[] data) {
        if (!this.checkSimpleNameMap(ciType)) {
            return null;
        }
        String type = this.descriptors.getRegisteredType(ciType);
        Artifact artifact = new Artifact(type);
        artifact.setValues(Maps.newHashMap(values));
        return new ArtifactAndData(artifact, data);
    }

    private boolean checkSimpleNameMap(String ciType) {
        boolean contains = this.descriptors.isTypeRegistered(ciType);
        if (!contains) {
            logger.error("Could not find CI with name {}", (Object)ciType);
        }
        return contains;
    }
}

