/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy;

import com.xebialabs.deployit.core.api.resteasy.DeployitClientException;
import com.xebialabs.deployit.core.api.resteasy.UnhandledException;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerErrorClientResponseInterceptor
implements ClientErrorInterceptor {
    private static final String NO_HEADER_PRESENT = "Found no header from Deployit! BAD situation... Please contact deployit-support@xebialabs.com";
    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);

    @Override
    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", clientResponse.getStatus());
        this.tryDeployitException(clientResponse);
        this.tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(ClientResponse<?> clientResponse) {
        if ("true".equals(clientResponse.getHeaders().getFirst("Unhandled-Exception"))) {
            logger.debug("Found unhandled header");
            String exceptionType = clientResponse.getHeaders().getFirst("Exception-Type");
            String unhandledMessage = clientResponse.getEntity(String.class);
            throw new UnhandledException(exceptionType, unhandledMessage);
        }
    }

    private void tryDeployitException(ClientResponse<?> clientResponse) {
        if ("true".equals(clientResponse.getHeaders().getFirst("Deployit-Exception"))) {
            logger.debug("Found Deployit header");
            String messages = clientResponse.getEntity(String.class);
            throw new DeployitClientException(messages);
        }
    }
}

