/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnPoolByRoute
extends AbstractConnPool {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpParams params;
    protected final ClientConnectionOperator operator;
    protected final Queue<BasicPoolEntry> freeConnections;
    protected final Queue<WaitingThread> waitingThreads;
    protected final Map<HttpRoute, RouteSpecificPool> routeToPool;

    public ConnPoolByRoute(ClientConnectionOperator operator2, HttpParams params) {
        if (operator2 == null) {
            throw new IllegalArgumentException("Connection operator may not be null");
        }
        this.operator = operator2;
        this.params = params;
        this.freeConnections = this.createFreeConnQueue();
        this.waitingThreads = this.createWaitingThreadQueue();
        this.routeToPool = this.createRouteToPoolMap();
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute route) {
        ConnPerRoute connPerRoute = ConnManagerParams.getMaxConnectionsPerRoute(this.params);
        return new RouteSpecificPool(route, connPerRoute.getMaxForRoute(route));
    }

    protected WaitingThread newWaitingThread(Condition cond, RouteSpecificPool rospl) {
        return new WaitingThread(cond, rospl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RouteSpecificPool getRoutePool(HttpRoute route, boolean create) {
        RouteSpecificPool rospl = null;
        this.poolLock.lock();
        try {
            rospl = this.routeToPool.get(route);
            if (rospl == null && create) {
                rospl = this.newRouteSpecificPool(route);
                this.routeToPool.put(route, rospl);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return rospl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HttpRoute route) {
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, false);
            int n = rospl != null ? rospl.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public PoolEntryRequest requestPoolEntry(final HttpRoute route, final Object state) {
        final WaitingThreadAborter aborter = new WaitingThreadAborter();
        return new PoolEntryRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void abortRequest() {
                ConnPoolByRoute.this.poolLock.lock();
                try {
                    aborter.abort();
                }
                finally {
                    ConnPoolByRoute.this.poolLock.unlock();
                }
            }

            public BasicPoolEntry getPoolEntry(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                return ConnPoolByRoute.this.getEntryBlocking(route, state, timeout, tunit, aborter);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute route, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        int maxTotalConnections = ConnManagerParams.getMaxTotalConnections(this.params);
        Date deadline = null;
        if (timeout > 0L) {
            deadline = new Date(System.currentTimeMillis() + tunit.toMillis(timeout));
        }
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            WaitingThread waitingThread = null;
            while (entry == null) {
                boolean hasCapacity;
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down.");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Total connections kept alive: " + this.freeConnections.size());
                    this.log.debug("Total issued connections: " + this.leasedConnections.size());
                    this.log.debug("Total allocated connection: " + this.numConnections + " out of " + maxTotalConnections);
                }
                if ((entry = this.getFreeEntry(rospl, state)) != null) {
                    break;
                }
                boolean bl = hasCapacity = rospl.getCapacity() > 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Available capacity: " + rospl.getCapacity() + " out of " + rospl.getMaxEntries() + " [" + route + "][" + state + "]");
                }
                if (hasCapacity && this.numConnections < maxTotalConnections) {
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (hasCapacity && !this.freeConnections.isEmpty()) {
                    this.deleteLeastUsedEntry();
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Need to wait for connection [" + route + "][" + state + "]");
                }
                if (waitingThread == null) {
                    waitingThread = this.newWaitingThread(this.poolLock.newCondition(), rospl);
                    aborter.setWaitingThread(waitingThread);
                }
                boolean success = false;
                try {
                    rospl.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    success = waitingThread.await(deadline);
                }
                finally {
                    rospl.removeThread(waitingThread);
                    this.waitingThreads.remove(waitingThread);
                }
                if (success || deadline == null || deadline.getTime() > System.currentTimeMillis()) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Releasing connection [" + route + "][" + entry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                this.closeConnection(entry.getConnection());
                return;
            }
            this.leasedConnections.remove(entry);
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            if (reusable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Pooling connection [" + route + "][" + entry.getState() + "]" + "; keep alive for " + validDuration + " " + timeUnit.toString());
                }
                rospl.freeEntry(entry);
                this.freeConnections.add(entry);
                this.idleConnHandler.add(entry.getConnection(), validDuration, timeUnit);
            } else {
                rospl.dropEntry();
                --this.numConnections;
            }
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl, Object state) {
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            boolean done = false;
            while (!done) {
                entry = rospl.allocEntry(state);
                if (entry != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Getting free connection [" + rospl.getRoute() + "][" + state + "]");
                    }
                    this.freeConnections.remove(entry);
                    boolean valid = this.idleConnHandler.remove(entry.getConnection());
                    if (!valid) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Closing expired free connection [" + rospl.getRoute() + "][" + state + "]");
                        }
                        this.closeConnection(entry.getConnection());
                        rospl.dropEntry();
                        --this.numConnections;
                        continue;
                    }
                    this.leasedConnections.add(entry);
                    done = true;
                    continue;
                }
                done = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("No free connections [" + rospl.getRoute() + "][" + state + "]");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new connection [" + rospl.getRoute() + "]");
        }
        BasicPoolEntry entry = new BasicPoolEntry(op, rospl.getRoute());
        this.poolLock.lock();
        try {
            rospl.createdEntry(entry);
            ++this.numConnections;
            this.leasedConnections.add(entry);
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting connection [" + route + "][" + entry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            this.closeConnection(entry.getConnection());
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.deleteEntry(entry);
            --this.numConnections;
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            this.idleConnHandler.remove(entry.getConnection());
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeastUsedEntry() {
        try {
            this.poolLock.lock();
            BasicPoolEntry entry = this.freeConnections.remove();
            if (entry != null) {
                this.deleteEntry(entry);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("No free connection to delete.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleLostEntry(HttpRoute route) {
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.dropEntry();
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            --this.numConnections;
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThread(RouteSpecificPool rospl) {
        WaitingThread waitingThread = null;
        this.poolLock.lock();
        try {
            if (rospl != null && rospl.hasThread()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on pool [" + rospl.getRoute() + "]");
                }
                waitingThread = rospl.nextThread();
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on any pool");
                }
                waitingThread = this.waitingThreads.remove();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.wakeup();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClosedConnections() {
        this.poolLock.lock();
        try {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (entry.getConnection().isOpen()) continue;
                iter.remove();
                this.deleteEntry(entry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.poolLock.lock();
        try {
            super.shutdown();
            Iterator ibpe = this.freeConnections.iterator();
            while (ibpe.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)ibpe.next();
                ibpe.remove();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing connection [" + entry.getPlannedRoute() + "][" + entry.getState() + "]");
                }
                this.closeConnection(entry.getConnection());
            }
            Iterator iwth = this.waitingThreads.iterator();
            while (iwth.hasNext()) {
                WaitingThread waiter = (WaitingThread)iwth.next();
                iwth.remove();
                waiter.wakeup();
            }
            this.routeToPool.clear();
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

