/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConnectionHeaderWrapper
implements MultivaluedMap<String, String> {
    private CaseInsensitiveMap<String> cachedHeaders = new CaseInsensitiveMap();
    private URLConnection connection;
    private ResteasyProviderFactory factory;

    public URLConnectionHeaderWrapper(URLConnection connection, ResteasyProviderFactory factory) {
        this.connection = connection;
        this.factory = factory;
    }

    public void sync() {
        for (Map.Entry<String, List<String>> entry : this.connection.getRequestProperties().entrySet()) {
            for (String string : entry.getValue()) {
                this.cachedHeaders.add(entry.getKey(), string);
            }
        }
    }

    @Override
    public void putSingle(String key, String value) {
        this.cachedHeaders.putSingle(key, value);
        this.addResponseHeader(key, value);
    }

    @Override
    public void add(String key, String value) {
        this.cachedHeaders.add(key, value);
        this.addResponseHeader(key, value);
    }

    protected void addResponseHeader(String key, Object value) {
        RuntimeDelegate.HeaderDelegate<?> delegate = this.factory.createHeaderDelegate(value.getClass());
        if (delegate != null) {
            this.connection.addRequestProperty(key.toLowerCase(), delegate.toString(value));
        } else {
            this.connection.addRequestProperty(key.toLowerCase(), value.toString());
        }
    }

    @Override
    public String getFirst(String key) {
        return this.cachedHeaders.getFirst(key);
    }

    @Override
    public int size() {
        return this.cachedHeaders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cachedHeaders.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.cachedHeaders.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.cachedHeaders.containsValue(o);
    }

    @Override
    public List<String> get(Object o) {
        return this.cachedHeaders.get(o);
    }

    @Override
    public List<String> put(String s, List<String> objs) {
        for (String obj : objs) {
            this.addResponseHeader(s, obj);
        }
        return this.cachedHeaders.put(s, objs);
    }

    @Override
    public List<String> remove(Object o) {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : map.entrySet()) {
            for (String obj : entry.getValue()) {
                this.add(entry.getKey(), obj);
            }
        }
    }

    @Override
    public void clear() {
        throw new RuntimeException("Removing a header is illegal for an HttpServletResponse");
    }

    @Override
    public Set<String> keySet() {
        return this.cachedHeaders.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.cachedHeaders.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.cachedHeaders.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.cachedHeaders.equals(o);
    }

    @Override
    public int hashCode() {
        return this.cachedHeaders.hashCode();
    }
}

