/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Wls8WeblogicDeployerStepBase
implements Step {
    public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/wls/step/";
    private static final String WEBLOGIC_DEPLOYER_WIN_TEMPLATE = "com/xebialabs/deployit/plugin/wls/step/weblogic_deployer_win.template";
    private static final String WEBLOGIC_DEPLOYER_UNX_TEMPLATE = "com/xebialabs/deployit/plugin/wls/step/weblogic_deployer_unix.template";
    protected String description;
    protected WlsDomain domain;

    public Wls8WeblogicDeployerStepBase(WlsDomain domain) {
        this.domain = domain;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected String generateWithVelocity(String templatePath, Map<String, String> context) {
        InputStream scriptIn;
        try {
            scriptIn = new ClassPathResource(templatePath).getInputStream();
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot read script template resource " + templatePath, exc);
        }
        try {
            String template = IOUtils.toString((InputStream)scriptIn);
            TemplateResolver r = new TemplateResolver(context);
            String string = r.resolveStrict(template);
            return string;
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot evaluate script template resource " + templatePath, exc);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptIn);
        }
    }

    protected int executeWeblogicDeployerScript(StepExecutionContext ctx, HostSession rhs, Map<String, String> velocityContext) {
        String evaluatedScript = this.generateScript(velocityContext);
        HostFile uploadedDeployScript = rhs.getTempFile("deployitWeblogicDeployer", this.getExtensionPath());
        uploadedDeployScript.put(IOUtils.toInputStream((String)evaluatedScript), (long)evaluatedScript.length());
        String path = uploadedDeployScript.getPath();
        return rhs.execute((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), new String[]{path});
    }

    private String getExtensionPath() {
        Host activeHost = this.domain.getActiveHost();
        String wlstExtension = activeHost.getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS ? ".cmd" : activeHost.getScriptExtension();
        return wlstExtension;
    }

    protected String generateScript(Map<String, String> context) {
        String evaluatedScript = "";
        switch (this.domain.getActiveHost().getOperatingSystemFamily()) {
            case UNIX: {
                return this.generateWithVelocity(WEBLOGIC_DEPLOYER_UNX_TEMPLATE, context);
            }
            case WINDOWS: {
                return this.generateWithVelocity(WEBLOGIC_DEPLOYER_WIN_TEMPLATE, context);
            }
        }
        throw new RuntimeException("OS is either Unix or Windows");
    }

    protected String findOutExtension(NamedDeployableArtifact artifact) {
        try {
            Field field = artifact.getClass().getField("ARCHIVE_EXTENSION");
            return "." + field.get(artifact).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected artifact " + artifact, e);
        }
    }
}

