#!/bin/sh
#
# Shell script to start Deployit
#

pluginsDir=lib

if [ "x$DEPLOYIT_HOME" = "x" ] ; then
  BIN_DIR=`dirname "$0"`
  cd "$BIN_DIR"
  ABSOLUTE_BIN_DIR=`pwd`
  DEPLOYIT_HOME=`dirname "$ABSOLUTE_BIN_DIR"`
fi
echo DEPLOYIT_HOME: $DEPLOYIT_HOME
cd "$DEPLOYIT_HOME"

cliJar=bin/deployit-3.0-cli.jar

if [ -d "${pluginsDir}" ]
then
  ls ${pluginsDir}/*.jar > /dev/null 2>&1
  if [ $? -eq 0 ]; then
    for pluginJar in `ls ${pluginsDir}/*.jar`
    do
      if [ -f $pluginJar ]; then
        cliClasspath=${cliClasspath}:${pluginJar}
      fi
    done
  fi
  ls ${pluginsDir}/* > /dev/null 2>&1

  if [ $? -eq 0 ]; then
    for expandedPluginDir in `ls ${pluginsDir}/*`
    do
      if [ -d $expandedPluginDir ]; then
        cliClasspath=${cliClasspath}:${expandedPluginDir}
      fi
    done
  fi
fi

if [ -z "$JAVA_HOME" ] ; then
  javaExec=java
else
  javaExec=${JAVA_HOME}/bin/java
fi

$javaExec -cp "${cliClasspath}" -jar ${cliJar} "$@"
