/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.pool.DbNameIndex;
import org.apache.jackrabbit.core.persistence.pool.NGKDbNameIndex;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.OracleConnectionHelper;

public class OraclePersistenceManager
extends BundleDbPersistenceManager {
    protected String tableSpace = "";

    public OraclePersistenceManager() {
        this.setExternalBLOBs(false);
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null && tableSpace.trim().length() > 0 ? "tablespace " + tableSpace.trim() : "";
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("oracle.jdbc.OracleDriver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe");
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("oracle");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix(context.getHomeDir().getName() + "_");
        }
        super.init(context);
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new NGKDbNameIndex(this.conHelper, this.schemaObjectPrefix);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        OracleConnectionHelper helper = new OracleConnectionHelper(dataSrc, this.blockOnConnectionLoss);
        helper.init();
        return helper;
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        return super.createCheckSchemaOperation().addVariableReplacement("${tableSpace}", this.tableSpace);
    }
}

