/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DynamicPooledExecutor
implements Executor {
    private final ThreadPoolExecutor executor;
    private long lastCheck;

    public DynamicPooledExecutor() {
        ThreadFactory f = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "DynamicPooledExecutor");
                t.setDaemon(true);
                return t;
            }
        };
        this.executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), f);
        this.lastCheck = System.currentTimeMillis();
    }

    private synchronized void adjustPoolSize() {
        long now = System.currentTimeMillis();
        if (this.lastCheck + 1000L < now) {
            int n = Runtime.getRuntime().availableProcessors();
            if (n != this.executor.getMaximumPoolSize()) {
                this.executor.setMaximumPoolSize(n);
            }
            this.lastCheck = now;
        }
    }

    public void execute(Runnable command) {
        this.adjustPoolSize();
        if (this.executor.getMaximumPoolSize() == 1) {
            command.run();
        } else {
            this.executor.execute(command);
        }
    }
}

