/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class DeploymentsForEnvironmentReport {
    private TaskArchive taskArchive;

    public DeploymentsForEnvironmentReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(String environment, Date date) {
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
        searchTasks.toEnvironment(environment).createdOnOrBefore(date.getCalendar());
        Report report = new Report();
        Collection searchResult = this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{"applicationName"}), new Function[]{new Function<Map<String, String>>(){

            public Map<String, String> invoke(Object previousValue, DeploymentTaskInfo task) {
                if (previousValue == null) {
                    return this.getTaskInfo(task);
                }
                Map<String, String> taskInfo = (Map<String, String>)previousValue;
                Date completionDate = new Date((String)taskInfo.get("date"));
                if (completionDate.compareTo(new Date(task.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ")) < 0) {
                    taskInfo = this.getTaskInfo(task);
                }
                return taskInfo;
            }

            private Map<String, String> getTaskInfo(DeploymentTaskInfo task) {
                HashMap value = Maps.newHashMap();
                value.put("deploymentType", task.getDeploymentType().name());
                value.put("user", task.getOwner());
                value.put("date", new Date(task.getCompletionDate(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ").toString());
                value.put("applicationVersion", task.getApplicationVersion());
                return value;
            }

            public String getName() {
                return "taskInfo";
            }
        }}));
        ArrayList searchResultList = Lists.newArrayList((Iterable)searchResult);
        Collections.sort(searchResultList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                Map lhsTaskInfo = (Map)lhs.get("taskInfo");
                Map rhsTaskInfo = (Map)rhs.get("taskInfo");
                Date lhsCompletionDate = new Date((String)lhsTaskInfo.get("date"));
                Date rhsCompletionDate = new Date((String)rhsTaskInfo.get("date"));
                return lhsCompletionDate.compareTo(rhsCompletionDate);
            }
        });
        for (Map task : searchResultList) {
            Map taskInfo = (Map)task.get("taskInfo");
            if (DeploymentTask.DeploymentType.valueOf((String)((String)taskInfo.get("deploymentType"))).equals((Object)DeploymentTask.DeploymentType.UNDEPLOY)) continue;
            Report.ReportLine line = report.addLine();
            line.addValue("application", task.get("applicationName"));
            line.addValue("version", taskInfo.get("applicationVersion"));
            line.addValue("user", taskInfo.get("user"));
            line.addValue("date", taskInfo.get("date"));
        }
        return report;
    }
}

