/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.collect.Sets;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overthere {
    private static final Logger logger = LoggerFactory.getLogger(Overthere.class);
    private static final AtomicReference<Map<String, Class<? extends OverthereConnectionBuilder>>> protocols = new AtomicReference(new HashMap());

    private Overthere() {
    }

    public static OverthereConnection getConnection(String protocol, ConnectionOptions options) {
        if (!protocols.get().containsKey(protocol)) {
            throw new IllegalArgumentException("Unknown connection protocol " + protocol);
        }
        if (logger.isTraceEnabled()) {
            HashSet filteredKeys = Sets.newHashSet((Object[])new String[]{"password", "passphrase"});
            logger.trace("Connection for protocol {} requested with the following connection options:", (Object)protocol);
            for (String k : options.keys()) {
                Object v = options.get(k);
                logger.trace("{}={}", (Object)k, !filteredKeys.contains(k) ? v : "********");
            }
        }
        Class<? extends OverthereConnectionBuilder> connectionBuilderClass = protocols.get().get(protocol);
        try {
            Constructor<? extends OverthereConnectionBuilder> constructor = connectionBuilderClass.getConstructor(String.class, ConnectionOptions.class);
            OverthereConnectionBuilder connectionBuilder = constructor.newInstance(protocol, options);
            logger.info("Connecting to {}", (Object)connectionBuilder);
            OverthereConnection connection = connectionBuilder.connect();
            logger.trace("Connected to {}", (Object)connection);
            return connection;
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalStateException(connectionBuilderClass + " does not have a constructor that takes in a String and ConnectionOptions.", exc);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (InstantiationException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (IllegalAccessException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (InvocationTargetException exc) {
            if (exc.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exc.getCause();
            }
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
    }

    static {
        Scannit scannit = new Scannit(Configuration.config().scan("com.xebialabs").with(new AbstractScanner[]{new TypeAnnotationScanner()}));
        Set protocolClasses = scannit.getTypesAnnotatedWith(Protocol.class);
        for (Class protocol : protocolClasses) {
            if (OverthereConnectionBuilder.class.isAssignableFrom(protocol)) {
                String name = protocol.getAnnotation(Protocol.class).name();
                protocols.get().put(name, protocol);
                continue;
            }
            logger.warn("Skipping class {} because it is not a HostConnectionBuilder.", (Object)protocol);
        }
    }
}

