/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OverthereConnection
implements Closeable {
    protected final String protocol;
    protected final OperatingSystemFamily os;
    protected final int connectionTimeoutMillis;
    protected final String temporaryDirectoryPath;
    protected final boolean deleteTemporaryDirectoryOnDisconnect;
    protected final int temporaryFileCreationRetries;
    protected final boolean canStartProcess;
    protected OverthereFile connectionTemporaryDirectory;
    protected OverthereFile workingDirectory;
    private static Logger logger = LoggerFactory.getLogger(OverthereConnection.class);

    protected OverthereConnection(String protocol, ConnectionOptions options, boolean canStartProcess) {
        this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (Object)"Cannot create HostConnection with null protocol");
        this.os = (OperatingSystemFamily)((Object)options.get("os"));
        this.connectionTimeoutMillis = options.get("connectionTimeoutMillis", 120000);
        this.temporaryDirectoryPath = options.get("tmp", this.os.getDefaultTemporaryDirectoryPath());
        this.deleteTemporaryDirectoryOnDisconnect = options.get("tmpDeleteOnDisconnect", true);
        this.temporaryFileCreationRetries = options.get("tmpFileCreationRetries", 100);
        this.canStartProcess = canStartProcess;
    }

    public final OperatingSystemFamily getHostOperatingSystem() {
        return this.os;
    }

    @Override
    public final void close() {
        if (this.deleteTemporaryDirectoryOnDisconnect) {
            this.deleteConnectionTemporaryDirectory();
        }
        this.doClose();
        logger.info("Disconnected from {}", (Object)this);
    }

    protected abstract void doClose();

    public abstract OverthereFile getFile(String var1);

    public abstract OverthereFile getFile(OverthereFile var1, String var2);

    public final OverthereFile getTempFile(String nameTemplate) {
        String suffix;
        String prefix;
        if (nameTemplate != null) {
            int pos = nameTemplate.lastIndexOf(47);
            if (pos != -1) {
                nameTemplate = nameTemplate.substring(pos + 1);
            }
            if ((pos = nameTemplate.lastIndexOf(92)) != -1) {
                nameTemplate = nameTemplate.substring(pos + 1);
            }
        }
        if (Strings.isNullOrEmpty((String)nameTemplate)) {
            prefix = "hostsession";
            suffix = ".tmp";
        } else {
            prefix = OverthereUtils.getBaseName(nameTemplate);
            suffix = "." + OverthereUtils.getExtension(nameTemplate);
        }
        return this.getTempFile(prefix, suffix);
    }

    public final OverthereFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random r = new Random();
        String infix = "";
        for (int i = 0; i < this.temporaryFileCreationRetries; ++i) {
            OverthereFile f = this.getFileForTempFile(this.getConnectionTemporaryDirectory(), prefix + infix + suffix);
            if (!f.exists()) {
                logger.debug("Created temporary file {}", (Object)f);
                return f;
            }
            infix = "-" + Long.toString(Math.abs(r.nextLong()));
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    private OverthereFile getConnectionTemporaryDirectory() throws RuntimeIOException {
        if (this.connectionTemporaryDirectory == null) {
            this.connectionTemporaryDirectory = this.createConnectionTemporaryDirectory();
        }
        return this.connectionTemporaryDirectory;
    }

    private OverthereFile createConnectionTemporaryDirectory() {
        OverthereFile temporaryDirectory = this.getFile(this.temporaryDirectoryPath);
        Random r = new Random();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String prefix = "overthere-" + dateFormat.format(new Date());
        String infix = "";
        String suffix = ".tmp";
        for (int i = 0; i < this.temporaryFileCreationRetries; ++i) {
            OverthereFile tempDir = this.getFileForTempFile(temporaryDirectory, prefix + infix + suffix);
            if (!tempDir.exists()) {
                tempDir.mkdir();
                logger.info("Created connection temporary directory {}", (Object)tempDir);
                return tempDir;
            }
            infix = "-" + Long.toString(Math.abs(r.nextLong()));
        }
        throw new RuntimeIOException("Cannot create connection temporary directory on " + this);
    }

    private void deleteConnectionTemporaryDirectory() {
        if (this.connectionTemporaryDirectory != null) {
            try {
                logger.info("Deleting connection temporary directory {}", (Object)this.connectionTemporaryDirectory);
                this.connectionTemporaryDirectory.deleteRecursively();
            }
            catch (RuntimeException exc) {
                logger.warn("Got exception while deleting connection temporary directory {}. Ignoring it.", (Object)this.connectionTemporaryDirectory, (Object)exc);
            }
        }
    }

    protected abstract OverthereFile getFileForTempFile(OverthereFile var1, String var2);

    public OverthereFile getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public int execute(final OverthereProcessOutputHandler handler, CmdLine commandLine) {
        final OverthereProcess process = this.startProcess(commandLine);
        Thread stdoutReaderThread = null;
        Thread stderrReaderThread = null;
        final CountDownLatch latch = new CountDownLatch(2);
        try {
            stdoutReaderThread = new Thread("Stdout reader thread for command " + commandLine + " on " + this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder lineBuffer = new StringBuilder();
                    InputStreamReader stdoutReader = new InputStreamReader(process.getStdout());
                    latch.countDown();
                    try {
                        int cInt = stdoutReader.read();
                        while (cInt > -1) {
                            char c = (char)cInt;
                            handler.handleOutput(c);
                            if (c != '\r' && c != '\n') {
                                lineBuffer.append(c);
                            }
                            if (c == '\n') {
                                handler.handleOutputLine(lineBuffer.toString());
                                lineBuffer.setLength(0);
                            }
                            cInt = stdoutReader.read();
                        }
                    }
                    catch (Exception exc) {
                        logger.error("An exception occured while reading from stdout", (Throwable)exc);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)stdoutReader);
                        if (lineBuffer.length() > 0) {
                            handler.handleOutputLine(lineBuffer.toString());
                        }
                    }
                }
            };
            stdoutReaderThread.start();
            stderrReaderThread = new Thread("Stderr reader thread for command " + commandLine + " on " + this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder lineBuffer = new StringBuilder();
                    InputStreamReader stderrReader = new InputStreamReader(process.getStderr());
                    latch.countDown();
                    try {
                        int readInt = stderrReader.read();
                        while (readInt > -1) {
                            char c = (char)readInt;
                            if (c != '\r' && c != '\n') {
                                lineBuffer.append(c);
                            }
                            if (c == '\n') {
                                handler.handleErrorLine(lineBuffer.toString());
                                lineBuffer.setLength(0);
                            }
                            readInt = stderrReader.read();
                        }
                    }
                    catch (Exception exc) {
                        logger.error("An exception occured while reading from stderr", (Throwable)exc);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)stderrReader);
                        if (lineBuffer.length() > 0) {
                            handler.handleErrorLine(lineBuffer.toString());
                        }
                    }
                }
            };
            stderrReaderThread.start();
            try {
                latch.await();
                int n = process.waitFor();
                return n;
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
                logger.info("Execution interrupted, destroying the process.");
                process.destroy();
                throw new RuntimeIOException("Execution interrupted", exc);
            }
        }
        finally {
            if (stdoutReaderThread != null) {
                try {
                    stdoutReaderThread.interrupt();
                    stdoutReaderThread.join();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
            if (stderrReaderThread != null) {
                try {
                    stderrReaderThread.interrupt();
                    stderrReaderThread.join();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on " + this);
    }

    public final boolean canStartProcess() {
        return this.canStartProcess;
    }

    public abstract String toString();
}

