/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.RegularExpressionPasswordResponseProvider;
import com.xebialabs.overthere.ssh.SshConnectionBuilder;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshProcess;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshConnection
extends OverthereConnection {
    public static final String PTY_PATTERN = "(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)";
    protected final SshConnectionType sshConnectionType;
    protected final String host;
    protected final int port;
    protected final String username;
    protected final String password;
    protected String interactiveKeyboardAuthPromptRegex;
    protected final String privateKeyFile;
    protected final String passphrase;
    protected final boolean allocateDefaultPty;
    protected final String allocatePty;
    protected SSHClient sshClient;
    private static final Pattern ptyPattern = Pattern.compile("(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)");
    @VisibleForTesting
    protected Factory<SSHClient> sshClientFactory = new Factory<SSHClient>(){

        public SSHClient create() {
            return new SSHClient();
        }
    };
    private static Logger logger = LoggerFactory.getLogger(SshConnection.class);

    public SshConnection(String protocol, ConnectionOptions options) {
        super(protocol, options, true);
        this.sshConnectionType = (SshConnectionType)((Object)options.get("connectionType"));
        this.host = (String)options.get("address");
        this.port = options.get("port", 22);
        this.username = (String)options.get("username");
        this.password = (String)options.getOptional("password");
        this.interactiveKeyboardAuthPromptRegex = options.get("interactiveKeyboardAuthRegex", ".*Password:[ ]?");
        this.privateKeyFile = (String)options.getOptional("privateKeyFile");
        this.passphrase = (String)options.getOptional("passphrase");
        this.allocateDefaultPty = options.get("allocateDefaultPty", false);
        this.allocatePty = options.get("allocatePty", SshConnectionBuilder.ALLOCATE_PTY_DEFAULT);
    }

    protected void connect() {
        try {
            SSHClient client = (SSHClient)this.sshClientFactory.create();
            client.setConnectTimeout(this.connectionTimeoutMillis);
            client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            try {
                client.connect(this.host, this.port);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot connect to " + this.host + ":" + this.port, e);
            }
            if (this.privateKeyFile != null) {
                KeyProvider keys;
                if (this.password != null) {
                    logger.warn("The privateKeyFile and password connection options have both been set for the connection {}. Ignoring password and using privateKeyFile.", (Object)this);
                }
                try {
                    keys = this.passphrase == null ? client.loadKeys(this.privateKeyFile) : client.loadKeys(this.privateKeyFile, this.passphrase);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Cannot read key from private key file " + this.privateKeyFile, e);
                }
                client.authPublickey(this.username, new KeyProvider[]{keys});
            } else if (this.password != null) {
                PasswordFinder passwordFinder = this.getPasswordFinder();
                client.auth(this.username, new AuthMethod[]{new AuthPassword(passwordFinder), new AuthKeyboardInteractive((ChallengeResponseProvider)new RegularExpressionPasswordResponseProvider(passwordFinder, this.interactiveKeyboardAuthPromptRegex))});
            }
            this.sshClient = client;
        }
        catch (SSHException e) {
            throw new RuntimeIOException("Cannot connect to " + this, e);
        }
    }

    private PasswordFinder getPasswordFinder() {
        return new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                return SshConnection.this.password.toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Already disconnected");
        try {
            this.sshClient.disconnect();
        }
        catch (Exception e) {
            logger.error("Unexpected exception received while disconnecting from " + this, (Throwable)e);
        }
        finally {
            this.sshClient = null;
        }
    }

    protected SSHClient getSshClient() {
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Not (yet) connected");
        return this.sshClient;
    }

    @Override
    public final OverthereFile getFile(String hostPath) throws RuntimeIOException {
        return this.getFile(hostPath, false);
    }

    @Override
    public final OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        return this.getFile(parent, child, false);
    }

    @Override
    protected final OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return this.getFile(parent, name, true);
    }

    protected abstract OverthereFile getFile(String var1, boolean var2) throws RuntimeIOException;

    protected OverthereFile getFile(OverthereFile parent, String child, boolean isTempFile) throws RuntimeIOException {
        if (!(parent instanceof SshFile)) {
            throw new IllegalStateException("parent is not a file on an SSH host");
        }
        if (parent.getConnection() != this) {
            throw new IllegalStateException("parent is not a file in this connection");
        }
        return this.getFile(parent.getPath() + this.getHostOperatingSystem().getFileSeparator() + child, isTempFile);
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        Preconditions.checkNotNull((Object)commandLine, (Object)"Cannot execute null command line");
        Preconditions.checkArgument((commandLine.getArguments().size() > 0 ? 1 : 0) != 0, (Object)"Cannot execute empty command line");
        CmdLine cmd = this.processCommandLine(commandLine);
        try {
            Session session = this.getSshClient().startSession();
            if (this.allocatePty != null && !this.allocatePty.isEmpty()) {
                if (this.allocateDefaultPty) {
                    logger.warn("The allocatePty and allocateDefaultPty connection options have both been set for the connection {}. Ignoring allocateDefaultPty and using allocatePty.", (Object)this);
                }
                Matcher matcher = ptyPattern.matcher(this.allocatePty);
                Preconditions.checkArgument((boolean)matcher.matches(), (String)"Value for allocatePty [%s] does not match pattern \"(\\w+):(\\d+):(\\d+):(\\d+):(\\d+)\"", (Object[])new Object[]{this.allocateDefaultPty});
                String term = matcher.group(1);
                int cols = Integer.valueOf(matcher.group(2));
                int rows = Integer.valueOf(matcher.group(3));
                int width = Integer.valueOf(matcher.group(4));
                int height = Integer.valueOf(matcher.group(5));
                logger.debug("Allocating PTY {}:{}:{}:{}:{}", new Object[]{term, cols, rows, width, height});
                session.allocatePTY(term, cols, rows, width, height, Collections.emptyMap());
            } else if (this.allocateDefaultPty) {
                logger.debug("Allocating default PTY");
                session.allocateDefaultPTY();
            }
            return this.createProcess(session, cmd);
        }
        catch (SSHException e) {
            throw new RuntimeIOException("Cannot execute remote command \"" + cmd.toCommandLine(this.getHostOperatingSystem(), true) + "\" on " + this, e);
        }
    }

    protected CmdLine processCommandLine(CmdLine commandLine) {
        if (this.getWorkingDirectory() != null) {
            CmdLine commandLineWithCd = new CmdLine();
            commandLineWithCd.addArgument("cd");
            commandLineWithCd.addArgument(this.workingDirectory.getPath());
            commandLineWithCd.addRaw(this.os.getCommandSeparator());
            for (CmdLineArgument a : commandLine.getArguments()) {
                commandLineWithCd.add(a);
            }
            return commandLineWithCd;
        }
        return commandLine;
    }

    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, commandLine);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.host + ":" + this.port;
    }
}

