/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.ByteArrayFile;
import java.io.UnsupportedEncodingException;

public class OverthereUtils {
    public static void write(byte[] from, OverthereFile to) {
        new ByteArrayFile(to.getPath(), from).copyTo(to);
    }

    public static void write(String from, String encoding, OverthereFile to) {
        try {
            OverthereUtils.write(from.getBytes(encoding), to);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeIOException("Cannot write string to " + to, exc);
        }
    }

    public static String getName(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(lastSlash + 1);
        }
        int lastBackslash = path.lastIndexOf(92);
        if (lastBackslash >= 0) {
            return path.substring(lastBackslash + 1);
        }
        return path;
    }

    public static String getBaseName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(0, dot);
        }
        return name;
    }

    public static String getExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            return name.substring(dot + 1);
        }
        return name;
    }
}

