/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.repository.NodeWriter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JcrRepositoryService
implements RepositoryService {
    private JcrTemplate jcrTemplate;

    @Autowired
    public JcrRepositoryService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public void execute(ChangeSet changeset) {
        this.jcrTemplate.execute(new ChangeSetExecutor(changeset));
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException {
        this.jcrTemplate.execute(new ReferentialIntegrityChecker(changeset));
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... entities) {
        ChangeSet changeset = new ChangeSet();
        changeset.setCreateCis(Lists.newArrayList((Object[])entities));
        this.execute(changeset);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return this._read(id, null);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return this._read(id, workDir);
    }

    private <T extends ConfigurationItem> T _read(final String id, final WorkDir workDir) {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws IOException, RepositoryException {
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    return NodeReader.read(session, node, workDir);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException(exc, "Repository entity [%s] not found", id);
                }
            }
        }));
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... cis) {
        ChangeSet changeset = new ChangeSet();
        changeset.setUpdateCis(Lists.newArrayList((Object[])cis));
        this.execute(changeset);
    }

    @Override
    public void delete(String ... ids) {
        ChangeSet changeset = new ChangeSet();
        changeset.setDeleteCiIds(Lists.newArrayList((Object[])ids));
        this.execute(changeset);
    }

    @Override
    public List<String> list(SearchParameters parameters) {
        Preconditions.checkNotNull((Object)parameters);
        List entities = this.listEntities(parameters);
        return Lists.transform(entities, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        });
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(final SearchParameters parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null");
        return (List)this.jcrTemplate.execute(new JcrCallback<List<T>>(){

            @Override
            public List<T> doInJcr(Session session) throws IOException, RepositoryException {
                Query query = new SearchQueryBuilder(parameters).build(session);
                QueryResult queryResult = query.execute();
                if (parameters.at != null) {
                    return JcrRepositoryService.this.getDistinctEntities(parameters, session, queryResult);
                }
                return JcrRepositoryService.this.getOrderedEntities(parameters, session, queryResult);
            }
        });
    }

    private <T extends ConfigurationItem> List<T> getDistinctEntities(SearchParameters parameters, Session session, QueryResult queryResult) throws RepositoryException, IOException {
        LinkedHashMap<String, Pair<T, Node>> nodes = new LinkedHashMap<String, Pair<T, Node>>();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                Node each = iterator.nextRow().getNode("ci");
                Pair pair = new Pair(NodeReader.read(session, each, null), each);
                if (!this.nodeNotFoundYetOrNewerThanNodeAlreadyFound(nodes, pair)) continue;
                nodes.put(((ConfigurationItem)pair.left).getId(), pair);
            }
            catch (RepositoryException rre) {}
        }
        return Lists.newArrayList((Iterable)Collections2.transform(nodes.values(), (Function)new Function<Pair<T, Node>, T>(){

            public T apply(Pair<T, Node> input) {
                return (ConfigurationItem)input.left;
            }
        }));
    }

    private <T extends ConfigurationItem> boolean nodeNotFoundYetOrNewerThanNodeAlreadyFound(Map<String, Pair<T, Node>> entities, Pair<T, Node> pair) throws RepositoryException {
        String path = ((ConfigurationItem)pair.left).getId();
        return !entities.containsKey(path) || this.getLastModified((Node)entities.get((Object)path).right).before(this.getLastModified((Node)pair.right));
    }

    private Calendar getLastModified(Node node) throws RepositoryException {
        return node.getProperty("$lastModified").getDate();
    }

    private <T extends ConfigurationItem> List<T> getOrderedEntities(SearchParameters parameters, Session session, QueryResult queryResult) throws RepositoryException, IOException {
        ArrayList nodes = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                Node each = iterator.nextRow().getNode("ci");
                nodes.add(new Pair(NodeReader.read(session, each, null), each));
            }
            catch (RepositoryException rre) {}
        }
        if (parameters.after != null || parameters.before != null) {
            Collections.sort(nodes, new Comparator<Pair<T, Node>>(){

                @Override
                public int compare(Pair<T, Node> lhs, Pair<T, Node> rhs) {
                    int diff = 0;
                    try {
                        diff = ((ConfigurationItem)lhs.left).getId().compareTo(((ConfigurationItem)rhs.left).getId());
                        if (diff != 0) {
                            return diff;
                        }
                        return JcrRepositoryService.this.getLastModified((Node)lhs.right).compareTo(JcrRepositoryService.this.getLastModified((Node)rhs.right));
                    }
                    catch (RepositoryException e) {
                        throw new IllegalStateException("Could not get path from node.", e);
                    }
                }
            });
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)nodes, (Function)new Function<Pair<T, Node>, T>(){

            public T apply(Pair<T, Node> input) {
                return (ConfigurationItem)input.left;
            }
        }));
    }

    @Override
    public boolean checkNodeExists(final String id) {
        return this.jcrTemplate.execute(new JcrCallback<Boolean>(){

            @Override
            public Boolean doInJcr(Session session) throws IOException, RepositoryException {
                return session.itemExists(JcrPathHelper.getAbsolutePathFromId(id));
            }
        });
    }

    static String generateJcrPropertyNameForNestedProperty(PropertyDescriptor pd, PropertyDescriptor nestedPd) {
        return pd.getName() + "_" + nestedPd.getName();
    }

    private class Pair<T, U> {
        T left;
        U right;

        private Pair(T left, U right) {
            this.left = left;
            this.right = right;
        }
    }

    private static class PropertyRef {
        private String owningNode;
        private String property;
        private String uuidOfReferencedNode;

        PropertyRef(String owningNode, String property, String uuidOfReferencedNode) {
            this.owningNode = owningNode;
            this.property = property;
            this.uuidOfReferencedNode = uuidOfReferencedNode;
        }
    }

    private static class ReferentialIntegrityChecker
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ReferentialIntegrityChecker(ChangeSet changeset) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(session);
            Multimap<String, PropertyRef> deletedEntityRefs = this.findReferencesToDeletedNodes(session);
            ChangeSetExecutor changeSetExecutor = new ChangeSetExecutor(this.changeset);
            changeSetExecutor.execute(session, false);
            try {
                this.checkForRemainingReferencesToDeletedNodes(deletedEntityRefs, session);
            }
            finally {
                session.refresh(false);
            }
            return null;
        }

        private void checkIfAnyOfTheEntitiesToBeCreatedAlreadyExists(Session session) throws RepositoryException {
            for (ConfigurationItem entity : this.changeset.getCreateCis()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(entity.getId()))) continue;
                throw new ItemAlreadyExistsException("Repository entity %s already exists", entity.getId());
            }
        }

        private Multimap<String, PropertyRef> findReferencesToDeletedNodes(Session session) throws RepositoryException {
            ArrayListMultimap deletedEntityRefs = ArrayListMultimap.create();
            for (String deleteNodeId : this.changeset.getDeleteCiIds()) {
                if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(deleteNodeId))) continue;
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(deleteNodeId));
                PropertyIterator references = node.getReferences();
                while (references.hasNext()) {
                    Property property = references.nextProperty();
                    Node parent = property.getParent();
                    deletedEntityRefs.put((Object)deleteNodeId, (Object)new PropertyRef(parent.getPath(), property.getName(), node.getIdentifier()));
                }
            }
            return deletedEntityRefs;
        }

        private void checkForRemainingReferencesToDeletedNodes(Multimap<String, PropertyRef> deletedEntityRefs, Session session) throws RepositoryException {
            for (String deleteNodeId : deletedEntityRefs.keySet()) {
                for (PropertyRef propertyRef : deletedEntityRefs.get((Object)deleteNodeId)) {
                    Value[] values;
                    Value[] valueArray;
                    Node owningNode;
                    if (!session.nodeExists(propertyRef.owningNode) || !(owningNode = session.getNode(propertyRef.owningNode)).hasProperty(propertyRef.property)) continue;
                    Property property = owningNode.getProperty(propertyRef.property);
                    if (property.isMultiple()) {
                        valueArray = property.getValues();
                    } else {
                        Value[] valueArray2 = new Value[1];
                        valueArray = valueArray2;
                        valueArray2[0] = property.getValue();
                    }
                    for (Value value : values = valueArray) {
                        if (!value.getString().equals(propertyRef.uuidOfReferencedNode)) continue;
                        throw new ItemInUseException("Repository entity %s is still referenced by %s", deleteNodeId, propertyRef.owningNode);
                    }
                }
            }
        }
    }

    private static class SortHierarchyComparator
    implements Comparator<ConfigurationItem> {
        private SortHierarchyComparator() {
        }

        @Override
        public int compare(ConfigurationItem o1, ConfigurationItem o2) {
            int nrSlashes1 = StringUtils.countOccurrencesOf((String)o1.getId(), (String)"/");
            int nrSlashes2 = StringUtils.countOccurrencesOf((String)o2.getId(), (String)"/");
            return nrSlashes1 - nrSlashes2;
        }
    }

    private static class ChangeSetExecutor
    implements JcrCallback<Object> {
        private final ChangeSet changeset;

        ChangeSetExecutor(ChangeSet changeset) {
            Preconditions.checkNotNull((Object)changeset);
            this.changeset = changeset;
        }

        @Override
        public Object doInJcr(Session session) throws IOException, RepositoryException {
            this.execute(session, true);
            return null;
        }

        public void execute(Session session, boolean autocommit) throws RepositoryException {
            try {
                this.createEntities(this.changeset.getCreateCis(), session);
                this.updateEntities(this.changeset.getUpdateCis(), session);
                this.deleteEntities(this.changeset.getDeleteCiIds(), session);
                if (autocommit) {
                    session.save();
                }
            }
            catch (ReferentialIntegrityException exc) {
                throw new ItemInUseException(exc, "Cannot delete configuration items [%s] because one of the configuration items, or one of their children, is still being referenced", Joiner.on((char)',').join(this.changeset.getDeleteCiIds()));
            }
        }

        private void createEntities(List<ConfigurationItem> entities, Session session) throws RepositoryException {
            this.verifyEntitiesMeetCreationPreconditions(entities);
            Collections.sort(entities, new SortHierarchyComparator());
            ArrayList writers = Lists.newArrayList();
            for (ConfigurationItem entity : entities) {
                Node node = this.createNode(entity, session);
                NodeWriter nodeWriter = new NodeWriter(session, entity, node);
                nodeWriter.writeBasics();
                writers.add(nodeWriter);
            }
            this.writeEntities(writers);
        }

        private void updateEntities(List<ConfigurationItem> entities, Session session) throws RepositoryException {
            List<Node> nodes = this.retrieveAndCheckpointNodesToBeUpdated(entities, session);
            for (int i = 0; i < entities.size(); ++i) {
                this.updateNode(entities.get(i), nodes.get(i), session);
            }
        }

        private void deleteEntities(List<String> entityIds, Session session) throws RepositoryException {
            List<Node> nodes = this.retrieveAndCheckpointNodesToBeDeleted(entityIds, session);
            for (Node node : nodes) {
                this.deleteNode(node);
            }
        }

        private List<Node> retrieveAndCheckpointNodesToBeUpdated(List<ConfigurationItem> entities, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (ConfigurationItem entity : entities) {
                Preconditions.checkNotNull((Object)entity, (Object)"entity is null");
                Preconditions.checkNotNull((Object)entity.getId(), (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(entity.getId()));
                    this.checkpoint(node, session);
                    nodes.add(node);
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Repository entity [%s] not found", entity.getId());
                }
            }
            return nodes;
        }

        private List<Node> retrieveAndCheckpointNodesToBeDeleted(List<String> ids, Session session) throws RepositoryException {
            ArrayList nodes = Lists.newArrayList();
            for (String id : ids) {
                Preconditions.checkNotNull((Object)id, (Object)"id is null");
                try {
                    Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                    this.checkpoint(node, session);
                    nodes.add(node);
                }
                catch (PathNotFoundException ignored) {}
            }
            return nodes;
        }

        private Node createNode(ConfigurationItem entity, Session session) throws RepositoryException {
            this.validateNodeStoredInCorrectPath(entity, session);
            Node node = session.getRootNode().addNode(entity.getId());
            int index = node.getIndex();
            if (index != 1) {
                node.remove();
                throw new ItemAlreadyExistsException("Repository entity with ID [%s] already exists", entity.getId());
            }
            this.setMixins(entity, node);
            return node;
        }

        private void updateNode(ConfigurationItem entity, Node node, Session session) throws RepositoryException {
            new NodeWriter(session, entity, node).write();
        }

        private void deleteNode(Node node) throws RepositoryException {
            node.remove();
        }

        private void checkpoint(Node node, Session session) throws RepositoryException {
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkpoint(node.getPath());
        }

        private void verifyEntitiesMeetCreationPreconditions(List<ConfigurationItem> cis) {
            for (int i = 0; i < cis.size(); ++i) {
                ConfigurationItem ci = cis.get(i);
                Preconditions.checkNotNull((Object)ci, (String)"ci at index %s is null.", (Object[])new Object[]{i});
                Preconditions.checkNotNull((Object)ci.getId(), (String)"ci at index %s has null id.", (Object[])new Object[]{i});
                if (!(ci instanceof SourceArtifact)) continue;
                Preconditions.checkArgument((((SourceArtifact)ci).getFile() != null ? 1 : 0) != 0, (String)"Artifact %s should have file", (Object[])new Object[]{ci.getId()});
            }
        }

        private void validateNodeStoredInCorrectPath(ConfigurationItem ci, Session session) throws RepositoryException {
            String id = ci.getId();
            Type type = ci.getType();
            Preconditions.checkArgument((boolean)DescriptorRegistry.exists((Type)type), (String)"Unknown configuration item type %s", (Object[])new Object[]{type});
            Descriptor desc = DescriptorRegistry.getDescriptor((Type)type);
            String[] pathElements = id.split("/");
            if (desc.getRoot() == Metadata.ConfigurationItemRoot.NESTED) {
                Checks.checkArgument(pathElements.length >= 3, "Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", type, id);
                String parentId = id.substring(0, id.lastIndexOf(47));
                Node parentNode = session.getNode(JcrPathHelper.getAbsolutePathFromId(parentId));
                Checks.checkArgument(parentNode != null, "Configuration item of type %s cannot be stored at %s. The parent does not exist", type, id);
                Checks.checkArgument(parentNode.isNodeType("deployit:configurationItem"), "Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", type, id);
                String parentTypeName = parentNode.getProperty("$configuration.item.type").getString();
                Descriptor parentDescriptor = DescriptorRegistry.getDescriptor((String)parentTypeName);
                for (PropertyDescriptor aPD : desc.getPropertyDescriptors()) {
                    if (aPD.getKind() != PropertyKind.CI || !aPD.isAsContainment() || !parentDescriptor.isAssignableTo(aPD.getReferencedType())) continue;
                    return;
                }
                for (PropertyDescriptor aPD : parentDescriptor.getPropertyDescriptors()) {
                    if (aPD.getKind() != PropertyKind.SET_OF_CI || !aPD.isAsContainment() || !desc.isAssignableTo(aPD.getReferencedType())) continue;
                    return;
                }
                throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", type, id);
            }
            Checks.checkArgument(pathElements.length == 2 && pathElements[0].equals(desc.getRoot().getRootNodeName()), "Configuration item of type %s cannot be stored at %s. It should be stored under %s", type, id, desc.getRoot().getRootNodeName());
        }

        private void setMixins(ConfigurationItem entity, Node node) throws RepositoryException {
            if (entity instanceof Artifact) {
                node.addMixin("deployit:artifact");
                node.addMixin("deployit:configurationItem");
            } else {
                node.addMixin("deployit:configurationItem");
            }
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }

        private void writeEntities(List<NodeWriter> writers) throws RepositoryException {
            for (NodeWriter writer : writers) {
                writer.write();
            }
        }
    }
}

