/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConsolidatedDictionary {
    private Map<String, String> entries = Maps.newHashMap();

    public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
        ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
        if (dicts != null) {
            for (Dictionary dict : dicts) {
                dictionary.addDictionary(dict);
            }
        }
        return dictionary;
    }

    void addDictionary(Dictionary d) {
        for (String k : d.getEntries().keySet()) {
            if (this.entries.containsKey(k) && !this.entries.get(k).equals(d.getEntries().get(k))) {
                throw new IllegalArgumentException("Flattened Dictionary already contains a value for key " + k);
            }
            this.entries.put(k, (String)d.getEntries().get(k));
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public String get(String key) {
        return this.entries.get(key);
    }

    public String resolve(String value) throws DictionaryValueException {
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries, false);
        if (value != null) {
            value = placeholderReplacer.replace(value);
        }
        return value;
    }

    public Object resolve(Object value, PropertyDescriptor deployablePropDesc) throws DictionaryValueException {
        if (value == null) {
            return null;
        }
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries, false);
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case SET_OF_CI: 
            case CI: 
            case ENUM: {
                return value;
            }
            case STRING: {
                return placeholderReplacer.replace((String)value);
            }
            case SET_OF_STRING: {
                return this.resolveSet((Set)value, placeholderReplacer);
            }
            case MAP_STRING_STRING: {
                return this.resolveMap((Map)value, placeholderReplacer);
            }
        }
        throw new IllegalStateException("Unknown property kind: " + deployablePropDesc.getKind());
    }

    private Object resolveMap(Map<String, String> value, MustachePlaceholderReplacer placeholderReplacer) {
        HashMap resolvedMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            try {
                resolvedMap.put(entry.getKey(), placeholderReplacer.replace(entry.getValue()));
            }
            catch (DictionaryValueException e) {
                resolvedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resolvedMap;
    }

    private Object resolveSet(Set<String> value, MustachePlaceholderReplacer placeholderReplacer) {
        HashSet resolved = Sets.newHashSet();
        for (String s : value) {
            try {
                resolved.add(placeholderReplacer.replace(s));
            }
            catch (DictionaryValueException e) {
                resolved.add(s);
            }
        }
        return resolved;
    }
}

