/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForkSerializer
extends ObjectInputStream {
    private final ClassLoader loader;

    public ForkSerializer(InputStream input, ClassLoader loader) throws IOException {
        super(input);
        this.loader = loader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return Class.forName(desc.getName(), false, this.loader);
    }

    static void serialize(DataOutputStream output, Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream serializer = new ObjectOutputStream(buffer);
        serializer.writeObject(object);
        serializer.close();
        byte[] data = buffer.toByteArray();
        output.writeInt(data.length);
        output.write(data);
    }

    static Object deserialize(DataInputStream input, ClassLoader loader) throws IOException, ClassNotFoundException {
        int n = input.readInt();
        byte[] data = new byte[n];
        input.readFully(data);
        ForkSerializer deserializer = new ForkSerializer(new ByteArrayInputStream(data), loader);
        return deserializer.readObject();
    }
}

