/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;

public class GpsDescriptor
extends TagDescriptor {
    public GpsDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(n);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(n);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
        }
        return this._directory.getString(n);
    }

    public String getGpsLatitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        return this.getHoursMinutesSecondsDescription(2);
    }

    public String getGpsLongitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(4)) {
            return null;
        }
        return this.getHoursMinutesSecondsDescription(4);
    }

    public String getHoursMinutesSecondsDescription(int n) throws MetadataException {
        Rational[] rationalArray = this._directory.getRationalArray(n);
        int n2 = rationalArray[0].intValue();
        float f = rationalArray[1].floatValue();
        float f2 = rationalArray[2].floatValue();
        return String.valueOf(n2) + "\"" + String.valueOf((int)f) + "'" + String.valueOf(f2 += f % 1.0f * 60.0f);
    }

    public String getGpsTimeStampDescription() throws MetadataException {
        if (!this._directory.containsTag(7)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(7);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray[0]);
        stringBuffer.append(":");
        stringBuffer.append(nArray[1]);
        stringBuffer.append(":");
        stringBuffer.append(nArray[2]);
        stringBuffer.append(" UTC");
        return stringBuffer.toString();
    }

    public String getGpsDestinationReferenceDescription() {
        if (!this._directory.containsTag(25)) {
            return null;
        }
        String string = this._directory.getString(25).trim();
        if ("K".equalsIgnoreCase(string)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(string)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(string)) {
            return "knots";
        }
        return "Unknown (" + string + ")";
    }

    public String getGpsDirectionDescription(int n) {
        if (!this._directory.containsTag(n)) {
            return null;
        }
        String string = this._directory.getString(n).trim();
        return string + " degrees";
    }

    public String getGpsDirectionReferenceDescription(int n) {
        if (!this._directory.containsTag(n)) {
            return null;
        }
        String string = this._directory.getString(n).trim();
        if ("T".equalsIgnoreCase(string)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(string)) {
            return "Magnetic direction";
        }
        return "Unknown (" + string + ")";
    }

    public String getGpsSpeedRefDescription() {
        if (!this._directory.containsTag(12)) {
            return null;
        }
        String string = this._directory.getString(12).trim();
        if ("K".equalsIgnoreCase(string)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(string)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(string)) {
            return "knots";
        }
        return "Unknown (" + string + ")";
    }

    public String getGpsMeasureModeDescription() {
        if (!this._directory.containsTag(10)) {
            return null;
        }
        String string = this._directory.getString(10).trim();
        if ("2".equalsIgnoreCase(string)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(string)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + string + ")";
    }

    public String getGpsStatusDescription() {
        if (!this._directory.containsTag(9)) {
            return null;
        }
        String string = this._directory.getString(9).trim();
        if ("A".equalsIgnoreCase(string)) {
            return "Measurement in progess";
        }
        if ("V".equalsIgnoreCase(string)) {
            return "Measurement Interoperability";
        }
        return "Unknown (" + string + ")";
    }

    public String getGpsAltitudeRefDescription() throws MetadataException {
        if (!this._directory.containsTag(5)) {
            return null;
        }
        int n = this._directory.getInt(5);
        if (n == 0) {
            return "Sea level";
        }
        return "Unknown (" + n + ")";
    }

    public String getGpsAltitudeDescription() throws MetadataException {
        if (!this._directory.containsTag(6)) {
            return null;
        }
        String string = this._directory.getRational(6).toSimpleString(true);
        return string + " metres";
    }
}

