/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
implements RoleService {
    private static final AtomicInteger groupNumber = new AtomicInteger(-1);
    private JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(RoleServiceImpl.class);

    @Autowired
    public RoleServiceImpl(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Override
    public List<Role> readRoles() {
        return this.jcrTemplate.execute(new JcrCallback<List<Role>>(){

            @Override
            public List<Role> doInJcr(Session session) throws IOException, RepositoryException {
                return RoleServiceImpl.this.readRoles(session);
            }
        });
    }

    @Override
    public List<Role> readRoleAssignments() {
        return this.jcrTemplate.execute(new JcrCallback<List<Role>>(){

            @Override
            public List<Role> doInJcr(Session session) throws IOException, RepositoryException {
                return RoleServiceImpl.this.readRoleAssignments(session);
            }
        });
    }

    @Override
    public void writeRoleAssignments(final List<Role> list) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                RoleServiceImpl.this.writeRoles(session, list);
                RoleServiceImpl.this.writeRoleAssignments(session, list);
                session.save();
                return null;
            }
        });
    }

    @Override
    public Role getRoleForRoleName(String string) {
        List<Role> list = this.readRoles();
        for (Role role : list) {
            if (!role.getName().equals(string)) continue;
            return role;
        }
        throw new NotFoundException("Could not find the role [%s]", string);
    }

    @Override
    public List<Role> getRolesFor(Authentication authentication) {
        Collection<String> collection = Permissions.authenticationToPrincipals(authentication);
        return this.getRolesFor(collection);
    }

    @Override
    public List<Role> getRolesFor(String string) {
        return this.getRolesFor(Lists.newArrayList((Object[])new String[]{string}));
    }

    private List<Role> readRoles(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        final ArrayList arrayList = Lists.newArrayList();
        JcrUtils.forEachNonJcrProperty(node, new JcrUtils.Callback<Property>(){

            @Override
            public void apply(Property property) throws RepositoryException {
                arrayList.add(new Role(Integer.valueOf(property.getName()), property.getString()));
            }
        });
        return arrayList;
    }

    private List<Role> readRoleAssignments(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        List<Role> list = this.readRoles();
        final ImmutableMap<Integer, Role> immutableMap = Permissions.buildLookup(list);
        JcrUtils.forEachNonJcrProperty(node, new JcrUtils.Callback<Property>(){

            @Override
            public void apply(Property property) throws RepositoryException {
                String string = property.getName();
                Iterable<Integer> iterable = Permissions.splitRoles(property.getString());
                for (Integer n : iterable) {
                    ((Role)immutableMap.get(n)).getPrincipalsAssigned().add(string);
                }
            }
        });
        return list;
    }

    private void writeRoles(Session session, List<Role> list) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        if (groupNumber.get() == -1) {
            groupNumber.compareAndSet(-1, this.readMaxRole(node) + 1);
        }
        JcrUtils.clearProperties(node);
        for (Role role : list) {
            if (role.getId() == null) {
                role.setId(groupNumber.getAndIncrement());
            }
            node.setProperty(role.getId().toString(), role.getName());
        }
    }

    private int readMaxRole(Node node) throws RepositoryException {
        final int[] nArray = new int[]{-1};
        JcrUtils.forEachNonJcrProperty(node, new JcrUtils.Callback<Property>(){

            @Override
            public void apply(Property property) throws RepositoryException {
                int n = Integer.valueOf(property.getName());
                if (n > nArray[0]) {
                    nArray[0] = n;
                }
            }
        });
        return nArray[0];
    }

    private List<Role> getRolesFor(final Collection<String> collection) {
        return this.jcrTemplate.execute(new JcrCallback<List<Role>>(){

            @Override
            public List<Role> doInJcr(Session session) throws IOException, RepositoryException {
                return RoleServiceImpl.this.principalsToRoles(session, collection);
            }
        });
    }

    private List<Role> principalsToRoles(Session session, Collection<String> collection) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        final ImmutableMap<Integer, Role> immutableMap = Permissions.buildLookup(this.readRoles());
        Function<Integer, Role> function = new Function<Integer, Role>(){

            public Role apply(Integer n) {
                return (Role)immutableMap.get((Object)n);
            }
        };
        ArrayList arrayList = Lists.newArrayList();
        for (String string : collection) {
            if (!node.hasProperty(string)) continue;
            Property property = node.getProperty(string);
            arrayList.addAll(Lists.newArrayList((Iterable)Iterables.transform(Permissions.splitRoles(property.getString()), (Function)function)));
        }
        logger.debug("Found roles {} for principals {}", (Object)arrayList, collection);
        return arrayList;
    }

    private void writeRoleAssignments(Session session, List<Role> list) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        JcrUtils.clearProperties(node);
        ListMultimap<String, Role> listMultimap = this.buildMap(list);
        for (String string : listMultimap.keySet()) {
            node.setProperty(string, Permissions.joinRoles(Iterables.transform((Iterable)listMultimap.get((Object)string), (Function)new Function<Role, Integer>(){

                public Integer apply(Role role) {
                    return role.getId();
                }
            })));
        }
    }

    private ListMultimap<String, Role> buildMap(List<Role> list) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Role role : list) {
            for (String string : role.getPrincipalsAssigned()) {
                arrayListMultimap.put((Object)string, (Object)role);
            }
        }
        return arrayListMultimap;
    }
}

