/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseStep<C extends ExecutionContext>
implements Step<C> {
    public static final String FREEMARKER_FILE_EXT = ".ftl";
    private String description;
    private HostContainer container;
    private String remoteWorkingDirPath;
    private boolean retainRemoteWorkingDirOnCompletion;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient C ctx;
    private transient OverthereFile remoteWorkingDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected BaseStep(String string, HostContainer hostContainer) {
        this.description = string;
        this.container = hostContainer;
    }

    protected BaseStep(HostContainer hostContainer) {
        this(null, hostContainer);
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result handleExecute(C c) throws Exception {
        try {
            this.ctx = c;
            Step.Result result = this.doExecute();
            return result;
        }
        finally {
            this.disconnect();
        }
    }

    protected abstract Step.Result doExecute() throws Exception;

    protected C getCtx() {
        return this.ctx;
    }

    protected HostContainer getContainer() {
        return this.container;
    }

    public OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile overthereFile = Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) ? this.getRemoteConnection().getTempFile("generic_plugin", ".tmp") : this.getRemoteConnection().getFile(this.getRemoteWorkingDirPath());
            overthereFile.mkdir();
            this.remoteWorkingDir = overthereFile;
        }
        return this.remoteWorkingDir;
    }

    public OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    public OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        if (this.localConn != null) {
            Closeables.closeQuietly((Closeable)this.localConn);
        }
        if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) && !this.isRetainRemoteWorkingDirOnCompletion()) {
            this.getRemoteWorkingDirectory().deleteRecursively();
        }
        if (this.remoteConn != null) {
            Closeables.closeQuietly((Closeable)this.remoteConn);
        }
        this.remoteWorkingDir = null;
        this.localConn = null;
        this.remoteConn = null;
    }

    public String getRemoteWorkingDirPath() {
        return this.remoteWorkingDirPath;
    }

    public void setRemoteWorkingDirPath(String string) {
        this.remoteWorkingDirPath = string;
    }

    public boolean isRetainRemoteWorkingDirOnCompletion() {
        return this.retainRemoteWorkingDirOnCompletion;
    }

    public void setRetainRemoteWorkingDirOnCompletion(boolean bl) {
        this.retainRemoteWorkingDirOnCompletion = bl;
    }

    protected OverthereFile uploadToWorkingDirectory(String string, String string2) {
        this.getCtx().logOutput("Uploading file " + string2 + " to working directory.");
        OverthereFile overthereFile = this.getRemoteWorkingDirectory().getFile(string2);
        OverthereUtils.write((byte[])string.getBytes(), (OverthereFile)overthereFile);
        return overthereFile;
    }

    protected OverthereFile uploadToWorkingDirectory(File file, String string) {
        String string2 = file.isDirectory() ? "directory" : "file";
        this.getCtx().logOutput("Uploading " + string2 + " " + string + " to working directory.");
        OverthereFile overthereFile = this.getRemoteWorkingDirectory().getFile(string);
        LocalFile.valueOf((File)file).copyTo(overthereFile);
        return overthereFile;
    }

    protected OverthereFile uploadToWorkingDirectory(URL uRL, String string) {
        this.getCtx().logOutput("Uploading file " + string + " to working directory.");
        OverthereFile overthereFile = this.getRemoteWorkingDirectory().getFile(string);
        OutputStream outputStream = overthereFile.getOutputStream();
        try {
            Resources.copy((URL)uRL, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)outputStream);
        }
        return overthereFile;
    }

    public boolean hostFileExists(String string) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string));
        OverthereFile overthereFile = this.getRemoteConnection().getFile(string);
        return overthereFile.exists();
    }

    public String getHostLineSeparator() {
        return this.getContainer().getHost().getOs().getLineSeparator();
    }

    public String getHostFileSeparator() {
        return this.getContainer().getHost().getOs().getFileSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readHostFile(String string) {
        String string2;
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string));
        OverthereFile overthereFile = this.getRemoteConnection().getFile(string);
        Preconditions.checkArgument((boolean)overthereFile.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{string, this.getContainer().getHost()});
        InputStream inputStream = overthereFile.getInputStream();
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
            string2 = new String(byArray);
        }
        catch (Throwable throwable) {
            try {
                Closeables.closeQuietly((Closeable)inputStream);
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Failed to read file " + string, (Throwable)iOException);
            }
        }
        Closeables.closeQuietly((Closeable)inputStream);
        return string2;
    }

    public String[] readHostFileLines(String string) {
        String string2 = this.readHostFile(string);
        Iterable iterable = Splitter.on((String)this.getHostLineSeparator()).split((CharSequence)string2);
        return (String[])Iterables.toArray((Iterable)iterable, String.class);
    }

    public void createOrReplaceHostFile(String string, String string2) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string2));
        Preconditions.checkNotNull((Object)string);
        OverthereFile overthereFile = this.getRemoteConnection().getFile(string2);
        if (overthereFile.exists()) {
            this.logger.debug("File " + string2 + " already exists. Will delete before attempting to write.");
            overthereFile.delete();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        OutputStream outputStream = overthereFile.getOutputStream();
        try {
            ByteStreams.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Failed to write to " + string2, (Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)byteArrayInputStream);
            Closeables.closeQuietly((Closeable)outputStream);
        }
    }

    public NodeModel readHostXmlFileAsModel(String string) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)string));
        OverthereFile overthereFile = this.getRemoteConnection().getFile(string);
        Preconditions.checkArgument((boolean)overthereFile.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{string, this.getContainer().getHost()});
        InputStream inputStream = overthereFile.getInputStream();
        try {
            NodeModel nodeModel = NodeModel.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true);
            return nodeModel;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Cannot read xml file " + string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Cannot read xml file " + string, sAXException);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot read xml file " + string, (Throwable)iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    public String evaluateTemplate(String string, Map<String, Object> map) {
        Configuration configuration = ConfigurationHolder.getConfiguration();
        try {
            Template template = configuration.getTemplate(string);
            StringWriter stringWriter = new StringWriter();
            template.createProcessingEnvironment(map, (Writer)stringWriter, (ObjectWrapper)new CiAwareObjectWrapper(new WorkingFolderUploader(this, this.getCtx()))).process();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException);
        }
    }

    protected void evaluateTemplate(OverthereFile overthereFile, String string, Map<String, Object> map) {
        Configuration configuration = ConfigurationHolder.getConfiguration();
        OutputStream outputStream = overthereFile.getOutputStream();
        try {
            Template template = configuration.getTemplate(string);
            template.process(map, (Writer)new OutputStreamWriter(outputStream));
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException);
        }
        finally {
            Closeables.closeQuietly((Closeable)outputStream);
        }
    }

    public String resolveOsSpecificTemplate(String string) {
        Object object;
        if (this.classpathResourceExists(string + FREEMARKER_FILE_EXT)) {
            return string + FREEMARKER_FILE_EXT;
        }
        String string2 = string;
        String string3 = this.substringAfterLast(string2, '.');
        if (string3 == null) {
            object = this.getContainer().getHost().getOs();
            string2 = string2 + object.getScriptExtension();
        }
        if (!this.classpathResourceExists(string2)) {
            object = string2 + FREEMARKER_FILE_EXT;
            if (!this.classpathResourceExists((String)object)) {
                throw new IllegalArgumentException("Resource " + string2 + " not found in classpath");
            }
            string2 = object;
        }
        return string2;
    }

    public boolean classpathResourceExists(String string) {
        return Thread.currentThread().getContextClassLoader().getResource(string) != null;
    }

    public String substringAfterLast(String string, char c, String string2) {
        String string3 = this.substringAfterLast(string, c);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String substringAfterLast(String string, char c) {
        int n = string.lastIndexOf(c);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private static class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();
        private C ctx;
        final /* synthetic */ BaseStep this$0;

        public WorkingFolderUploader(C c) {
            this.this$0 = var1_1;
            this.ctx = c;
        }

        @Override
        public String upload(OverthereFile overthereFile) {
            if (this.uploadedFiles.containsKey(overthereFile.getName())) {
                return this.uploadedFiles.get(overthereFile.getName());
            }
            OverthereFile overthereFile2 = this.this$0.getRemoteWorkingDirectory().getFile(overthereFile.getName());
            if (!overthereFile2.exists()) {
                String string = overthereFile.isDirectory() ? "directory" : "file";
                this.ctx.logOutput("Uploading " + string + " " + overthereFile.getName() + " to working directory.");
                overthereFile.copyTo(overthereFile2);
            } else {
                this.this$0.logger.warn("Not uploading file " + overthereFile.getName() + " to working directory again because it has already been uploaded.");
            }
            this.uploadedFiles.put(overthereFile.getName(), overthereFile2.getPath());
            return overthereFile2.getPath();
        }
    }
}

