/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.Role;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import com.xebialabs.deployit.core.api.dto.RoleAssignments;
import com.xebialabs.deployit.core.api.dto.RolePermission;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.utils.Strings;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DtoReader {
    public static final Function<ConfigurationItemData, ConfigurationItemId> ciDataToCiId = new Function<ConfigurationItemData, ConfigurationItemId>(){

        public ConfigurationItemId apply(ConfigurationItemData configurationItemData) {
            return new ConfigurationItemId(configurationItemData.getId(), configurationItemData.getType().toString());
        }
    };
    public static final Function<ConfigurationItemId, ConfigurationItemData> ciIdToCiData = new Function<ConfigurationItemId, ConfigurationItemData>(){

        public ConfigurationItemData apply(ConfigurationItemId configurationItemId) {
            Type type = Strings.isBlank((String)configurationItemId.getType()) ? null : Type.valueOf((String)configurationItemId.getType());
            return new ConfigurationItemData(configurationItemId.getId(), type);
        }
    };

    public List<com.xebialabs.deployit.security.Role> readRoleAssignments(RoleAssignments roleAssignments) {
        ArrayList arrayList = Lists.newArrayList();
        for (RoleAssignment roleAssignment : roleAssignments.getAssignments()) {
            Role role = roleAssignment.getRole();
            com.xebialabs.deployit.security.Role role2 = this.readRole(role);
            List list = roleAssignment.getPrincipals();
            role2.getPrincipalsAssigned().addAll(list);
            arrayList.add(role2);
        }
        return arrayList;
    }

    private com.xebialabs.deployit.security.Role readRole(Role role) {
        return new com.xebialabs.deployit.security.Role(role.getId(), role.getName());
    }

    public Multimap<com.xebialabs.deployit.security.Role, Permission> readRolePermissions(RolePermissions rolePermissions, List<com.xebialabs.deployit.security.Role> list) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (RolePermission rolePermission : rolePermissions.getRolePermissions()) {
            com.xebialabs.deployit.security.Role role = this.readRole(rolePermission.getRole());
            if (role.getId() == null) {
                role = this.findRole(role.getName(), list);
            }
            List list2 = Lists.transform((List)rolePermission.getPermissions(), (Function)new Function<String, Permission>(){

                public Permission apply(String string) {
                    return Permission.find((String)string);
                }
            });
            hashMultimap.putAll((Object)role, (Iterable)list2);
        }
        return hashMultimap;
    }

    private com.xebialabs.deployit.security.Role findRole(String string, List<com.xebialabs.deployit.security.Role> list) {
        for (com.xebialabs.deployit.security.Role role : list) {
            if (!role.getName().equals(string)) continue;
            return role;
        }
        throw new IllegalArgumentException(String.format("Couldn't find role with name [%s]", string));
    }
}

