/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.xfer.FilePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpFile
extends SshFile<SshSftpConnection> {
    private static Logger logger = LoggerFactory.getLogger(SshSftpFile.class);

    public SshSftpFile(SshSftpConnection sshSftpConnection, String string) {
        super(sshSftpConnection, string);
    }

    protected String getSftpPath() {
        return ((SshSftpConnection)this.connection).pathToSftpPath(this.getPath());
    }

    @Override
    public boolean exists() {
        logger.debug("Checking file " + this + " for existence");
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().statExistence(this.getSftpPath()) != null;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot check existence of file " + this.getPath(), iOException);
        }
    }

    @Override
    public boolean isFile() {
        return this.stat().getType() == FileMode.Type.REGULAR;
    }

    @Override
    public boolean isDirectory() {
        return this.stat().getType() == FileMode.Type.DIRECTORY;
    }

    @Override
    public long lastModified() {
        return this.stat().getMtime();
    }

    @Override
    public long length() {
        return this.stat().getSize();
    }

    @Override
    public boolean canRead() {
        return this.hasPermission(FilePermission.USR_R);
    }

    @Override
    public boolean canWrite() {
        return this.hasPermission(FilePermission.USR_W);
    }

    @Override
    public boolean canExecute() {
        return this.hasPermission(FilePermission.USR_X);
    }

    private boolean hasPermission(FilePermission filePermission) {
        return this.stat().getPermissions().contains(filePermission);
    }

    protected FileAttributes stat() {
        logger.debug("Statting file " + this);
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath());
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot stat file " + this, iOException);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        logger.debug("Listing files in {}", (Object)this);
        try {
            List list = ((SshSftpConnection)this.connection).getSharedSftpClient().ls(this.getSftpPath());
            ArrayList arrayList = Lists.newArrayList();
            for (RemoteResourceInfo remoteResourceInfo : list) {
                String string = remoteResourceInfo.getName();
                if (string.equals(".") || string.equals("..")) continue;
                arrayList.add(this.getFile(string));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot list directory " + this, iOException);
        }
    }

    @Override
    public void mkdir() {
        logger.debug("Creating directory " + this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdir(this.getSftpPath());
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot create directory " + this, iOException);
        }
    }

    @Override
    public void mkdirs() {
        logger.debug("Creating directories {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdirs(this.getSftpPath());
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot create directories " + this, iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void renameTo(OverthereFile overthereFile) {
        logger.debug("Renaming {} to {}", (Object)this, (Object)overthereFile);
        if (!(overthereFile instanceof SshSftpFile)) throw new RuntimeIOException("Cannot move/rename ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + overthereFile);
        SshSftpFile sshSftpFile = (SshSftpFile)overthereFile;
        if (sshSftpFile.getConnection() != this.getConnection()) throw new RuntimeIOException("Cannot move/rename ssh:" + ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to file/directory " + overthereFile + " because it is in a different connection");
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rename(this.getSftpPath(), sshSftpFile.getSftpPath());
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot move/rename file/directory " + this + " to " + overthereFile, iOException);
        }
    }

    @Override
    public void setExecutable(boolean bl) {
        logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)bl);
        try {
            int n = ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath()).getMode().getPermissionsMask();
            n = bl ? (n |= 0x49) : (n &= 0xFFFFFFB6);
            ((SshSftpConnection)this.connection).getSharedSftpClient().chmod(this.path, n);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot delete file " + this, iOException);
        }
    }

    @Override
    protected void deleteFile() {
        logger.debug("Removing file {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rm(this.getSftpPath());
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot delete file " + this, iOException);
        }
    }

    @Override
    protected void deleteDirectory() {
        logger.debug("Removing directory {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rmdir(this.getSftpPath());
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot delete directory " + this, iOException);
        }
    }

    @Override
    public InputStream getInputStream() {
        logger.debug("Opening SFTP input stream to read from file {}", (Object)this);
        try {
            final RemoteFile remoteFile = ((SshSftpConnection)this.connection).getSharedSftpClient().open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.READ}));
            final RemoteFile.RemoteFileInputStream remoteFileInputStream = remoteFile.getInputStream();
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return remoteFileInputStream.read();
                }

                @Override
                public int read(byte[] byArray) throws IOException {
                    return remoteFileInputStream.read(byArray);
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    return remoteFileInputStream.read(byArray, n, n2);
                }

                @Override
                public long skip(long l) throws IOException {
                    return remoteFileInputStream.skip(l);
                }

                @Override
                public int available() throws IOException {
                    return remoteFileInputStream.available();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)remoteFile);
                    }
                }

                @Override
                public void mark(int n) {
                    remoteFileInputStream.mark(n);
                }

                @Override
                public void reset() throws IOException {
                    remoteFileInputStream.reset();
                }

                @Override
                public boolean markSupported() {
                    return remoteFileInputStream.markSupported();
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot read from file " + this, iOException);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening SFTP ouput stream to write to file {}", (Object)this);
        try {
            RemoteFile remoteFile = ((SshSftpConnection)this.connection).getSharedSftpClient().open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.CREAT, OpenMode.WRITE, OpenMode.TRUNC}));
            RemoteFile.RemoteFileOutputStream remoteFileOutputStream = remoteFile.getOutputStream();
            return new OutputStream((OutputStream)remoteFileOutputStream, remoteFile){
                final /* synthetic */ OutputStream val$wrapped;
                final /* synthetic */ RemoteFile val$remoteFile;
                {
                    this.val$wrapped = outputStream;
                    this.val$remoteFile = remoteFile;
                }

                @Override
                public void write(int n) throws IOException {
                    this.val$wrapped.write(n);
                }

                @Override
                public void write(byte[] byArray) throws IOException {
                    this.val$wrapped.write(byArray);
                }

                @Override
                public void write(byte[] byArray, int n, int n2) throws IOException {
                    this.val$wrapped.write(byArray, n, n2);
                }

                @Override
                public void flush() throws IOException {
                    this.val$wrapped.flush();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        this.val$wrapped.close();
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)this.val$remoteFile);
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot write to file " + this, iOException);
        }
    }
}

