/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.freemarker;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.overthere.OverthereFile;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CiTemplateModel
extends BeanModel {
    private static final String FILE_ATTRIBUTE = "file";
    private Descriptor descriptor;
    private ConfigurationItem ci;
    private CiAwareObjectWrapper wrapper;

    public CiTemplateModel(ConfigurationItem configurationItem, CiAwareObjectWrapper ciAwareObjectWrapper) {
        super((Object)configurationItem, (BeansWrapper)ciAwareObjectWrapper);
        this.ci = configurationItem;
        this.wrapper = ciAwareObjectWrapper;
        this.descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
    }

    public TemplateModel get(String string) throws TemplateModelException {
        PropertyDescriptor propertyDescriptor;
        if (string.equals(FILE_ATTRIBUTE)) {
            if (this.ci instanceof DeployableArtifact) {
                return this.handleDeployableArtifactFile();
            }
            if (this.ci instanceof DerivedArtifact) {
                return this.handleDerivedArtifactFile();
            }
        }
        if ((propertyDescriptor = this.descriptor.getPropertyDescriptor(string)) == null) {
            return super.get(string);
        }
        return this.wrapper.wrap(this.extractValueFromCi(propertyDescriptor));
    }

    private Object extractValueFromCi(PropertyDescriptor propertyDescriptor) {
        HashMap hashMap = Maps.newHashMap();
        if (this.ci instanceof AbstractDeployed) {
            hashMap.put("deployed", this.ci);
        } else if (this.ci instanceof Container || this.ci instanceof NestedContainer) {
            hashMap.put("container", this.ci);
        }
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                return ConfigurationHolder.resolveExpression((String)propertyDescriptor.get(this.ci), (Object)hashMap);
            }
            case SET_OF_STRING: {
                return ConfigurationHolder.resolveExpression((Set)propertyDescriptor.get(this.ci), (Object)hashMap);
            }
            case LIST_OF_STRING: {
                return ConfigurationHolder.resolveExpression((List)propertyDescriptor.get(this.ci), (Object)hashMap);
            }
            case MAP_STRING_STRING: {
                return ConfigurationHolder.resolveExpression((Map)propertyDescriptor.get(this.ci), hashMap);
            }
        }
        return propertyDescriptor.get(this.ci);
    }

    private TemplateModel handleDeployableArtifactFile() throws TemplateModelException {
        return this.uploadFile(((DeployableArtifact)this.ci).getFile());
    }

    private TemplateModel handleDerivedArtifactFile() throws TemplateModelException {
        return this.uploadFile(((DerivedArtifact)this.ci).getFile());
    }

    private TemplateModel uploadFile(OverthereFile overthereFile) throws TemplateModelException {
        Object object = overthereFile;
        if (this.wrapper.getUploader() != null) {
            object = this.wrapper.getUploader().upload(overthereFile);
        }
        return this.wrapper.wrap(object);
    }

    public boolean isEmpty() {
        return false;
    }
}

