/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOverthereConnection
implements OverthereConnection {
    protected final String protocol;
    protected final OperatingSystemFamily os;
    protected final int connectionTimeoutMillis;
    protected final String temporaryDirectoryPath;
    protected final boolean deleteTemporaryDirectoryOnDisconnect;
    protected final int temporaryFileCreationRetries;
    protected final boolean canStartProcess;
    protected OverthereFile connectionTemporaryDirectory;
    protected OverthereFile workingDirectory;
    protected final AddressPortMapper mapper;
    private static Logger logger = LoggerFactory.getLogger(BaseOverthereConnection.class);

    protected BaseOverthereConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper, boolean bl) {
        this.protocol = (String)Preconditions.checkNotNull((Object)string, (Object)"Cannot create OverthereConnection with null protocol");
        this.os = (OperatingSystemFamily)((Object)connectionOptions.get("os"));
        this.connectionTimeoutMillis = connectionOptions.get("connectionTimeoutMillis", 120000);
        this.temporaryDirectoryPath = connectionOptions.get("tmp", this.os.getDefaultTemporaryDirectoryPath());
        this.deleteTemporaryDirectoryOnDisconnect = connectionOptions.get("tmpDeleteOnDisconnect", true);
        this.temporaryFileCreationRetries = connectionOptions.get("tmpFileCreationRetries", 100);
        this.canStartProcess = bl;
        this.mapper = (AddressPortMapper)Preconditions.checkNotNull((Object)addressPortMapper, (Object)"Cannot create OverthereConnection with null addres-port mapper");
    }

    @Override
    public final OperatingSystemFamily getHostOperatingSystem() {
        return this.os;
    }

    @Override
    public final void close() {
        if (this.deleteTemporaryDirectoryOnDisconnect) {
            this.deleteConnectionTemporaryDirectory();
        }
        this.doClose();
        Closeables.closeQuietly((Closeable)this.mapper);
        logger.info("Disconnected from {}", (Object)this);
    }

    protected abstract void doClose();

    @Override
    public final OverthereFile getTempFile(String string) {
        String string2;
        String string3;
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(92)) != -1) {
                string = string.substring(n + 1);
            }
        }
        if (Strings.isNullOrEmpty((String)string)) {
            string3 = "hostsession";
            string2 = ".tmp";
        } else {
            string3 = OverthereUtils.getBaseName(string);
            string2 = "." + OverthereUtils.getExtension(string);
        }
        return this.getTempFile(string3, string2);
    }

    @Override
    public final OverthereFile getTempFile(String string, String string2) throws RuntimeIOException {
        if (string == null) {
            throw new NullPointerException("prefix is null");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        Random random = new Random();
        String string3 = "";
        for (int i = 0; i < this.temporaryFileCreationRetries; ++i) {
            OverthereFile overthereFile = this.getFileForTempFile(this.getConnectionTemporaryDirectory(), string + string3 + string2);
            if (!overthereFile.exists()) {
                logger.debug("Created temporary file {}", (Object)overthereFile);
                return overthereFile;
            }
            string3 = "-" + Long.toString(Math.abs(random.nextLong()));
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    private OverthereFile getConnectionTemporaryDirectory() throws RuntimeIOException {
        if (this.connectionTemporaryDirectory == null) {
            this.connectionTemporaryDirectory = this.createConnectionTemporaryDirectory();
        }
        return this.connectionTemporaryDirectory;
    }

    private OverthereFile createConnectionTemporaryDirectory() {
        OverthereFile overthereFile = this.getFile(this.temporaryDirectoryPath);
        Random random = new Random();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String string = "overthere-" + simpleDateFormat.format(new Date());
        String string2 = "";
        String string3 = ".tmp";
        for (int i = 0; i < this.temporaryFileCreationRetries; ++i) {
            OverthereFile overthereFile2 = this.getFileForTempFile(overthereFile, string + string2 + string3);
            if (!overthereFile2.exists()) {
                overthereFile2.mkdir();
                logger.info("Created connection temporary directory {}", (Object)overthereFile2);
                return overthereFile2;
            }
            string2 = "-" + Long.toString(Math.abs(random.nextLong()));
        }
        throw new RuntimeIOException("Cannot create connection temporary directory on " + this);
    }

    private void deleteConnectionTemporaryDirectory() {
        if (this.connectionTemporaryDirectory != null) {
            try {
                logger.info("Deleting connection temporary directory {}", (Object)this.connectionTemporaryDirectory);
                this.connectionTemporaryDirectory.deleteRecursively();
            }
            catch (RuntimeException runtimeException) {
                logger.warn("Got exception while deleting connection temporary directory {}. Ignoring it.", (Object)this.connectionTemporaryDirectory, (Object)runtimeException);
            }
        }
    }

    protected abstract OverthereFile getFileForTempFile(OverthereFile var1, String var2);

    @Override
    public OverthereFile getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(OverthereFile overthereFile) {
        this.workingDirectory = overthereFile;
    }

    @Override
    public int execute(final OverthereProcessOutputHandler overthereProcessOutputHandler, CmdLine cmdLine) {
        final OverthereProcess overthereProcess = this.startProcess(cmdLine);
        Thread thread = null;
        Thread thread2 = null;
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        try {
            thread = new Thread("Stdout reader thread for command " + cmdLine + " on " + this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder = new StringBuilder();
                    InputStreamReader inputStreamReader = new InputStreamReader(overthereProcess.getStdout());
                    countDownLatch.countDown();
                    try {
                        int n = inputStreamReader.read();
                        while (n > -1) {
                            char c = (char)n;
                            overthereProcessOutputHandler.handleOutput(c);
                            if (c != '\r' && c != '\n') {
                                stringBuilder.append(c);
                            }
                            if (c == '\n') {
                                overthereProcessOutputHandler.handleOutputLine(stringBuilder.toString());
                                stringBuilder.setLength(0);
                            }
                            n = inputStreamReader.read();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("An exception occured while reading from stdout", (Throwable)exception);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)inputStreamReader);
                        if (stringBuilder.length() > 0) {
                            overthereProcessOutputHandler.handleOutputLine(stringBuilder.toString());
                        }
                    }
                }
            };
            thread.start();
            thread2 = new Thread("Stderr reader thread for command " + cmdLine + " on " + this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StringBuilder stringBuilder = new StringBuilder();
                    InputStreamReader inputStreamReader = new InputStreamReader(overthereProcess.getStderr());
                    countDownLatch.countDown();
                    try {
                        int n = inputStreamReader.read();
                        while (n > -1) {
                            char c = (char)n;
                            if (c != '\r' && c != '\n') {
                                stringBuilder.append(c);
                            }
                            if (c == '\n') {
                                overthereProcessOutputHandler.handleErrorLine(stringBuilder.toString());
                                stringBuilder.setLength(0);
                            }
                            n = inputStreamReader.read();
                        }
                    }
                    catch (Exception exception) {
                        logger.error("An exception occured while reading from stderr", (Throwable)exception);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)inputStreamReader);
                        if (stringBuilder.length() > 0) {
                            overthereProcessOutputHandler.handleErrorLine(stringBuilder.toString());
                        }
                    }
                }
            };
            thread2.start();
            try {
                countDownLatch.await();
                int n = overthereProcess.waitFor();
                return n;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.info("Execution interrupted, destroying the process.");
                overthereProcess.destroy();
                throw new RuntimeIOException("Execution interrupted", interruptedException);
            }
        }
        finally {
            if (thread != null) {
                try {
                    thread.interrupt();
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (thread2 != null) {
                try {
                    thread2.interrupt();
                    thread2.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmdLine) {
        throw new UnsupportedOperationException("Cannot start a process on " + this);
    }

    @Override
    public final boolean canStartProcess() {
        return this.canStartProcess;
    }

    @Override
    public abstract String toString();
}

