/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import com.xebialabs.overthere.ssh.SshConnection;

abstract class SshFile<C extends SshConnection>
extends BaseOverthereFile<C> {
    protected String path;

    SshFile(C c, String string) {
        super(c);
        this.path = ((BaseOverthereConnection)c).getHostOperatingSystem() != OperatingSystemFamily.WINDOWS ? string : string.replace('/', '\\');
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    @Override
    public String getName() {
        String string = ((SshConnection)this.connection).getHostOperatingSystem().getFileSeparator();
        int n = this.path.lastIndexOf(string);
        if (n < 0) {
            return this.path;
        }
        return this.path.substring(n + 1);
    }

    @Override
    public OverthereFile getParentFile() {
        String string = ((SshConnection)this.connection).getHostOperatingSystem().getFileSeparator();
        int n = this.path.lastIndexOf(string);
        if (n < 0 || this.path.equals(string)) {
            return null;
        }
        if (n == 0) {
            return ((SshConnection)this.connection).getFile(string);
        }
        return ((SshConnection)this.connection).getFile(this.path.substring(0, n));
    }

    @Override
    public void delete() throws RuntimeIOException {
        if (this.exists()) {
            if (this.isDirectory()) {
                this.deleteDirectory();
            } else {
                this.deleteFile();
            }
        }
    }

    protected abstract void deleteFile();

    protected abstract void deleteDirectory();

    protected int executeCommand(OverthereProcessOutputHandler overthereProcessOutputHandler, CmdLine cmdLine) {
        return ((SshConnection)this.connection).execute(overthereProcessOutputHandler, cmdLine);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SshFile)) {
            return false;
        }
        return this.path.equals(((SshFile)object).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        String string = this.getPath();
        if (string.length() >= 1 && string.charAt(0) == '/') {
            return this.getConnection() + string;
        }
        return this.getConnection() + "/" + string;
    }
}

