/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NAME_IS_OPERATOR = "NAME_IS";
    private static final String NAME_LIKE_OPERATOR = "NAME_LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(SearchParameters searchParameters) {
        this.parameters = searchParameters;
        this.joins = new StringBuilder();
        this.conditions = Lists.newArrayList();
        Checks.checkArgument(searchParameters.name == null || !searchParameters.name.contains("'"), "Name [%s] contains a single quote (')", searchParameters.name);
        Checks.checkArgument(searchParameters.parent == null || !searchParameters.parent.contains("'"), "Parent [%s] contains a single quote (')", searchParameters.parent);
    }

    public Query build(Session session) throws RepositoryException {
        this.createJoinsAndConditions();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        String string = this.constructQueryString();
        Query query = queryManager.createQuery(string, "JCR-SQL2");
        this.addBinds(valueFactory, query);
        this.addPagingInfo(query);
        logger.debug("JCR query built: {}", (Object)query.getStatement());
        return query;
    }

    private String constructQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ci.* FROM [deployit:configurationItem] AS ci");
        stringBuilder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(Joiner.on((String)" AND ").join((Iterable)Collections2.transform(this.conditions, (Function)new Function<Condition, String>(){

                public String apply(Condition condition) {
                    return condition.build();
                }
            })));
        }
        stringBuilder.append(" ORDER BY NAME(ci)");
        logger.debug("Query string built: {}", (Object)stringBuilder.toString());
        return stringBuilder.toString();
    }

    private void addBinds(ValueFactory valueFactory, Query query) throws RepositoryException {
        for (Condition condition : this.conditions) {
            if (condition.parameter == null) continue;
            for (int i = 0; i < condition.values.length; ++i) {
                Value value;
                Object object = condition.values[i];
                if (object instanceof String) {
                    value = valueFactory.createValue((String)object);
                } else if (object instanceof Calendar) {
                    value = valueFactory.createValue((Calendar)object);
                } else {
                    throw new IllegalArgumentException("Value of Condition is not a String or a Calendar but a " + object.getClass().getName());
                }
                query.bindValue(condition.parameter + i, value);
                logger.debug("Bound {} to {}", (Object)(condition.parameter + i), (Object)value.getString());
            }
        }
    }

    void addPagingInfo(Query query) {
        if (this.parameters.resultsPerPage > 0L) {
            query.setLimit(this.parameters.resultsPerPage);
            query.setOffset(this.parameters.page * this.parameters.resultsPerPage);
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForName();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForDate();
        this.createConditionsForProperties();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (this.parameters.type != null) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.parameters.type.toString());
            for (Type type : DescriptorRegistry.getSubtypes((Type)this.parameters.type)) {
                arrayList.add(type.toString());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, arrayList.toArray(new String[arrayList.size()])));
        }
    }

    private void createConditionForParent() {
        if (!Strings.nullToEmpty((String)this.parameters.parent).trim().isEmpty()) {
            String string = Strings.nullToEmpty((String)this.parameters.parent);
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.conditions.add(Condition.isChildNode(CI_SELECTOR_NAME, string));
        }
    }

    private void createConditionForName() {
        if (!Strings.nullToEmpty((String)this.parameters.name).trim().isEmpty()) {
            if (this.parameters.name.contains("%")) {
                this.conditions.add(Condition.nameLike(CI_SELECTOR_NAME, this.parameters.name));
            } else {
                this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, this.parameters.name));
            }
        }
    }

    private void createConditionForDate() {
        if (this.parameters.before != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_before", "<=", this.parameters.before));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry<String, String> entry : this.parameters.properties.entrySet()) {
            this.createConditionForProperty(entry.getKey(), entry.getValue());
        }
    }

    private void createConditionForProperty(String string, String string2) {
        PropertyDescriptor propertyDescriptor;
        Descriptor descriptor;
        if (this.parameters.type != null && (descriptor = DescriptorRegistry.getDescriptor((Type)this.parameters.type)) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(string)) != null) {
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                String string3 = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + string3 + " ON " + CI_SELECTOR_NAME + ".[" + string + "] = " + string3 + ".[jcr:uuid]");
                int n = string2.lastIndexOf(47);
                Preconditions.checkArgument((n != -1 ? 1 : 0) != 0, (Object)(string2 + " is a ID but does not contain a slash (/)"));
                String string4 = JcrPathHelper.getAbsolutePathFromId(string2.substring(0, n));
                String string5 = string2.substring(n + 1);
                this.conditions.add(Condition.isChildNode(string3, string4));
                this.conditions.add(Condition.nameIs(string3, string5));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, string, string, string2));
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String NAME_IS_FORMAT = "NAME(%s) = '%s'";
        private static final String NAME_LIKE_FORMAT = "LOWER(NAME(%s)) LIKE '%s'";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";

        private Condition() {
        }

        String build() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_IS_OPERATOR)) {
                    stringBuilder.append(String.format(NAME_IS_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_LIKE_OPERATOR)) {
                    stringBuilder.append(String.format(NAME_LIKE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    stringBuilder.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                stringBuilder.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        static Condition match(String string, String string2, String string3, String string4) {
            boolean bl;
            String string5;
            if (string4.contains("%")) {
                string5 = SearchQueryBuilder.LIKE_OPERATOR;
                bl = true;
            } else {
                string5 = SearchQueryBuilder.EQUALITY_OPERATOR;
                bl = false;
            }
            return Condition.from(string, string2, string3, string5, bl, string4);
        }

        static Condition nameIs(String string, String string2) {
            return Condition.from(string, null, null, SearchQueryBuilder.NAME_IS_OPERATOR, false, string2);
        }

        static Condition nameLike(String string, String string2) {
            return Condition.from(string, null, null, SearchQueryBuilder.NAME_LIKE_OPERATOR, false, string2.toLowerCase());
        }

        static Condition isChildNode(String string, String string2) {
            return Condition.from(string, null, null, SearchQueryBuilder.ISCHILDNODE_OPERATOR, false, string2);
        }

        static Condition from(String string, String string2, String string3, String string4, Object object) {
            return Condition.from(string, string2, string3, string4, false, object);
        }

        static Condition from(String string, String string2, String string3, String string4, boolean bl, Object ... objectArray) {
            Condition condition = new Condition();
            condition.selector = string;
            condition.field = string2;
            condition.parameter = string3;
            condition.operator = string4;
            condition.caseInsensitive = bl;
            condition.values = objectArray;
            return condition;
        }
    }
}

