/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.SecurityCallback;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityTemplate {
    public static <T> T executeAsAdmin(SecurityCallback<T> securityCallback) {
        return SecurityTemplate.executeAs("admin", "admin", securityCallback);
    }

    public static <T> T executeAs(Authentication authentication, SecurityCallback<T> securityCallback) {
        return SecurityTemplate.executeAs(authentication.getName(), "", securityCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAs(String string, String string2, SecurityCallback<T> securityCallback) {
        Authentication authentication = SecurityTemplate.setCredentials(string, string2);
        try {
            T t = securityCallback.doAs();
            return t;
        }
        finally {
            SecurityTemplate.restoreAuthentication(authentication);
        }
    }

    public static Authentication setCredentials(String string, String string2) {
        return SecurityTemplate.setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)string, (Object)string2));
    }

    public static Authentication setAuthentication(Authentication authentication) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication2 = securityContext.getAuthentication();
        securityContext.setAuthentication(authentication);
        return authentication2;
    }

    public static void restoreAuthentication(Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }
}

