/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsolidatedDictionary {
    private Map<String, String> entries = Maps.newHashMap();

    public static ConsolidatedDictionary create(Collection<Dictionary> collection) {
        ConsolidatedDictionary consolidatedDictionary = new ConsolidatedDictionary();
        if (collection != null) {
            for (Dictionary dictionary : collection) {
                consolidatedDictionary.addDictionary(dictionary);
            }
        }
        return consolidatedDictionary;
    }

    void addDictionary(Dictionary dictionary) {
        for (String string : dictionary.getEntries().keySet()) {
            if (this.entries.containsKey(string) && !this.entries.get(string).equals(dictionary.getEntries().get(string))) {
                throw new IllegalArgumentException("Flattened Dictionary already contains a value for key " + string);
            }
            this.entries.put(string, (String)dictionary.getEntries().get(string));
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public boolean containsKey(String string) {
        return this.entries.containsKey(string);
    }

    public String get(String string) {
        return this.entries.get(string);
    }

    public String resolve(String string) throws DictionaryValueException {
        MustachePlaceholderReplacer mustachePlaceholderReplacer = new MustachePlaceholderReplacer(this.entries, false);
        if (string != null) {
            string = mustachePlaceholderReplacer.replace(string);
        }
        return string;
    }

    public Object resolve(Object object, PropertyDescriptor propertyDescriptor) throws DictionaryValueException {
        if (object == null) {
            return null;
        }
        MustachePlaceholderReplacer mustachePlaceholderReplacer = new MustachePlaceholderReplacer(this.entries, false);
        switch (propertyDescriptor.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case SET_OF_CI: 
            case LIST_OF_CI: 
            case CI: 
            case ENUM: {
                return object;
            }
            case STRING: {
                return mustachePlaceholderReplacer.replace((String)object);
            }
            case SET_OF_STRING: {
                return Sets.newHashSet(this.resolveCollection((Set)object, mustachePlaceholderReplacer));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(this.resolveCollection((List)object, mustachePlaceholderReplacer));
            }
            case MAP_STRING_STRING: {
                return this.resolveMap((Map)object, mustachePlaceholderReplacer);
            }
        }
        throw new IllegalStateException("Unknown property kind: " + propertyDescriptor.getKind());
    }

    private Object resolveMap(Map<String, String> map, MustachePlaceholderReplacer mustachePlaceholderReplacer) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                hashMap.put(entry.getKey(), mustachePlaceholderReplacer.replace(entry.getValue()));
            }
            catch (DictionaryValueException dictionaryValueException) {
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    private Collection<String> resolveCollection(Collection<String> collection, MustachePlaceholderReplacer mustachePlaceholderReplacer) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : collection) {
            try {
                arrayList.add(mustachePlaceholderReplacer.replace(string));
            }
            catch (DictionaryValueException dictionaryValueException) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

