/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.util.Tuple;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit37Security
extends Upgrade {
    public static final Joiner PRINCIPAL_JOINER = Joiner.on((String)",").skipNulls();
    private static final EnumSet<Permission> RELATED_ACL_PERMISSIONS = EnumSet.of(Permission.DEPLOY_INITIAL, Permission.DEPLOY_UPGRADE, Permission.UNDEPLOY);
    private static final EnumSet<Permission> EX_GLOBAL_PERMISSIONS = EnumSet.of(Permission.READ, new Permission[]{Permission.IMPORT_INITIAL, Permission.IMPORT_UPGRADE, Permission.DEPLOY_INITIAL, Permission.DEPLOY_UPGRADE, Permission.UNDEPLOY, Permission.EDIT_REPO});
    private static final Function<Value, String> VALUE_TO_STRING = new Function<Value, String>(){

        public String apply(Value value) {
            try {
                return value.getString();
            }
            catch (RepositoryException repositoryException) {
                logger.error("Couldn't convert value to string", (Throwable)repositoryException);
                throw new UpgradeException("Couldn't convert value to string", new Object[0]);
            }
        }
    };
    private static final String GLOBAL = "<global>";
    private static final Splitter PATH_SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private static final String DIRECTORY_PREFIX = "migration-dir-";
    private static final Logger logger = LoggerFactory.getLogger(Deployit37Security.class);

    public boolean doUpgrade(RawRepository rawRepository) throws UpgradeException {
        logger.info("*** Running Deployit 3.7.0 Security Upgrade ***");
        Node node = rawRepository.read("/$configuration/security");
        try {
            Map<String, ListMultimap<Permission, String>> map = this.analyzePermissionStructure(node);
            logger.info("This is the analyzed permission structure:");
            this.logPermissionStructure(map);
            this.removeNonExistingNodesFromAnalyzedStructure(map, rawRepository);
            this.removeDeniesFromAnalyzedStructure(map, rawRepository);
            Map<String, HashMultimap<Permission, String>> map2 = this.filterDuplicateGrants(map);
            this.removeNonTopLevelPermissions(map2);
            this.fixinNonInheritanceInNewStructure(map2);
            Map<String, String> map3 = this.mapToDirectories(map2);
            this.remapPermissionStructure(map2, map3);
            this.mapGlobalPermissionsToConfigurationItems(map2);
            this.addImportRemoveToApplications(map2);
            logger.info("This will be the new Permission Structure:");
            this.logPermissionStructure(map2);
            this.clearAllAcls(map, rawRepository);
            this.createNewRepositoryStructure(map3, rawRepository);
            this.makeRootNodesVersionable(rawRepository);
            Set<String> set = this.gatherAllKnownPrincipals(map2);
            logger.info("Found the following principals known to Deployit: [{}]", set);
            List<Role> list = this.convertToRoles(set);
            this.writeRoles(list, rawRepository);
            this.writeRoleAssignments(list, rawRepository);
            this.writeNewPermissions(map2, list, rawRepository, node);
        }
        catch (RepositoryException repositoryException) {
            logger.error("Exception while upgrading security", (Throwable)repositoryException);
            throw new UpgradeException("Caught an exception while upgrading to 3.7 Security, please send the server log.", new Object[0]);
        }
        logger.info("*** Finished Upgrade ***");
        return true;
    }

    private void makeRootNodesVersionable(RawRepository rawRepository) throws RepositoryException {
        for (Metadata.ConfigurationItemRoot configurationItemRoot : EnumSet.complementOf(EnumSet.of(Metadata.ConfigurationItemRoot.NESTED))) {
            Node node = rawRepository.read(JcrPathHelper.getAbsolutePathFromId(configurationItemRoot.getRootNodeName()));
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }
    }

    private void logPermissionStructure(Map<String, ? extends Multimap<Permission, String>> map) {
        ArrayList arrayList = Lists.newArrayList(map.keySet());
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(String.format("On node [%s]:\n", string));
            for (Map.Entry entry : map.get(string).asMap().entrySet()) {
                stringBuilder.append(String.format("\t%s=%s\n", ((Permission)((Object)entry.getKey())).getPermissionName(), entry.getValue()));
            }
            stringBuilder.append("\n");
        }
        logger.info("\n{}", (Object)stringBuilder);
    }

    private Map<String, ListMultimap<Permission, String>> analyzePermissionStructure(Node node) throws RepositoryException {
        logger.info("Analyzing the existing permission structure");
        final ConcurrentMap concurrentMap = new MapMaker().makeComputingMap((Function)new Function<String, ListMultimap<Permission, String>>(){

            public ListMultimap<Permission, String> apply(String string) {
                return ArrayListMultimap.create();
            }
        });
        JcrUtils.forEachNonJcrProperty(node, new JcrUtils.Callback<Property>(){

            @Override
            public void apply(Property property) throws RepositoryException {
                String string = property.getName();
                List list = Deployit37Security.transformValuesToPermissions(property);
                logger.debug("Found permissions [{}] granted to [{}]", (Object)list, (Object)string);
                for (Tuple tuple : list) {
                    String string2 = (String)tuple.getB();
                    Permission permission = (Permission)((Object)tuple.getA());
                    String string3 = string2.equals(Deployit37Security.GLOBAL) ? string2 : JcrPathHelper.getAbsolutePathFromId(string2);
                    logger.debug("Adding to migration: permission [{}] on [{}] granted to [{}]", new Object[]{permission, string3, string});
                    ((ListMultimap)concurrentMap.get(string3)).put((Object)permission, (Object)string);
                }
                property.remove();
            }
        });
        return concurrentMap;
    }

    private void removeNonExistingNodesFromAnalyzedStructure(Map<String, ListMultimap<Permission, String>> map, RawRepository rawRepository) {
        logger.info("Removing non-existing nodes from the analyzed permission structure");
        ArrayList arrayList = Lists.newArrayList();
        for (String string : map.keySet()) {
            boolean bl;
            if (string.equals(GLOBAL)) continue;
            try {
                bl = rawRepository.read(string) != null;
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            logger.info("Removing node [{}] with permissions [{}] from migration as it no longer exists.", (Object)string, map.get(string));
            map.remove(string);
        }
    }

    private void removeDeniesFromAnalyzedStructure(Map<String, ListMultimap<Permission, String>> map, RawRepository rawRepository) throws RepositoryException {
        logger.info("Cleaning denies from the analyzed permission structure");
        for (String string : map.keySet()) {
            AccessControlPolicy[] accessControlPolicyArray;
            ListMultimap<Permission, String> listMultimap = map.get(string);
            if (!listMultimap.containsKey((Object)Permission.READ)) {
                logger.debug("Node [{}] does not have any read permissions", (Object)string);
                continue;
            }
            AccessControlManager accessControlManager = Deployit37Security.getAccessControlManager(rawRepository);
            for (AccessControlPolicy accessControlPolicy : accessControlPolicyArray = accessControlManager.getPolicies(string)) {
                if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
                JackrabbitAccessControlList jackrabbitAccessControlList = (JackrabbitAccessControlList)accessControlPolicy;
                for (AccessControlEntry accessControlEntry : jackrabbitAccessControlList.getAccessControlEntries()) {
                    if (!(accessControlEntry instanceof JackrabbitAccessControlEntry)) continue;
                    boolean bl = ((JackrabbitAccessControlEntry)accessControlEntry).isAllow();
                    Privilege[] privilegeArray = accessControlEntry.getPrivileges();
                    if (bl || privilegeArray.length != 1 || !privilegeArray[0].getName().equals("jcr:read")) continue;
                    Principal principal = accessControlEntry.getPrincipal();
                    listMultimap.get((Object)Permission.READ).remove(principal.getName());
                    logger.warn("Not migrating denied READ permission granted to [{}] on [{}]", (Object)principal.getName(), (Object)string);
                }
            }
        }
    }

    private Map<String, HashMultimap<Permission, String>> filterDuplicateGrants(Map<String, ListMultimap<Permission, String>> map) {
        logger.info("Filtering duplicate principals from grants");
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<String, ListMultimap<Permission, String>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), HashMultimap.create((Multimap)((Multimap)entry.getValue())));
        }
        return hashMap;
    }

    private void removeNonTopLevelPermissions(Map<String, HashMultimap<Permission, String>> map) {
        logger.info("Removing all permissions not granted to the first 2 levels of the repository.");
        HashSet hashSet = Sets.newHashSet((Iterable)Sets.filter(map.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return Iterables.size((Iterable)PATH_SPLITTER.split((CharSequence)string)) > 2;
            }
        }));
        for (String string : hashSet) {
            HashMultimap<Permission, String> hashMultimap = map.get(string);
            logger.warn("Not migrating permissions on node [{}] ({})", (Object)string, hashMultimap);
            map.remove(string);
        }
    }

    private void fixinNonInheritanceInNewStructure(Map<String, HashMultimap<Permission, String>> map) {
        logger.info("Consolidating the new permission structure");
        ArrayList arrayList = Lists.newArrayList(map.keySet());
        Collections.sort(arrayList);
        logger.debug("Sorted the nodes in parent->child order: {}", (Object)arrayList);
        Stack<String> stack = new Stack<String>();
        for (String string : arrayList) {
            while (!stack.isEmpty()) {
                String string2 = (String)stack.peek();
                if (string.startsWith(string2)) {
                    logger.debug("Copying read/repo#edit permissions from [{}] to [{}]", (Object)string2, (Object)string);
                    Multimap multimap = (Multimap)map.get(string2);
                    Multimap multimap2 = (Multimap)map.get(string);
                    Deployit37Security.copyPermissions((Multimap<Permission, String>)multimap, (Multimap<Permission, String>)multimap2, Permission.READ);
                    Deployit37Security.copyPermissions((Multimap<Permission, String>)multimap, (Multimap<Permission, String>)multimap2, Permission.EDIT_REPO);
                    break;
                }
                stack.pop();
            }
            stack.push(string);
        }
    }

    private Map<String, String> mapToDirectories(Map<String, HashMultimap<Permission, String>> map) {
        logger.info("Separating permission structure to groups");
        Map map2 = Maps.filterKeys(map, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return string.indexOf("/", 1) > -1;
            }
        });
        ImmutableListMultimap immutableListMultimap = Multimaps.index(map2.keySet(), (Function)new Function<String, String>(){

            public String apply(String string) {
                return (String)PATH_SPLITTER.split((CharSequence)string).iterator().next();
            }
        });
        logger.trace("Indexed nodes from permission structure to roots: {}", (Object)immutableListMultimap);
        logger.debug("Building mapping from permissions -> directories");
        HashMap hashMap = Maps.newHashMap();
        int n = 1;
        HashSet hashSet = Sets.newHashSet(map2.values());
        for (Object object : hashSet) {
            hashMap.put(object, DIRECTORY_PREFIX + n++);
        }
        logger.trace("Permission -> directory: {}", (Object)hashMap);
        HashMap hashMap2 = Maps.newHashMap();
        for (Map.Entry entry : immutableListMultimap.asMap().entrySet()) {
            String string = JcrPathHelper.getAbsolutePathFromId((String)entry.getKey());
            Collection collection = (Collection)entry.getValue();
            for (String string2 : collection) {
                HashMultimap hashMultimap = (HashMultimap)map2.get(string2);
                String string3 = (String)hashMap.get(hashMultimap);
                if (string3 == null) continue;
                hashMap2.put(string2, PATH_JOINER.join((Object)string, (Object)string3, new Object[0]));
            }
        }
        logger.debug("Mapped nodes to directories: {}", (Object)hashMap2);
        return hashMap2;
    }

    private void remapPermissionStructure(Map<String, HashMultimap<Permission, String>> map, Map<String, String> map2) {
        logger.info("Remapping the permission structure to groups.");
        for (String string : Sets.newHashSet(map.keySet())) {
            String string2 = map2.get(string);
            if (string2 == null) continue;
            HashMultimap<Permission, String> hashMultimap = map.get(string);
            map.remove(string);
            map.put(string2, hashMultimap);
        }
    }

    private void mapGlobalPermissionsToConfigurationItems(Map<String, HashMultimap<Permission, String>> map) {
        logger.info("Mapping old global permissions to configuration items.");
        HashMultimap hashMultimap = map.get(GLOBAL);
        if (hashMultimap == null) {
            hashMultimap = HashMultimap.create();
        }
        Set set = Sets.filter(map.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return !string.equals(Deployit37Security.GLOBAL);
            }
        });
        for (Permission permission : EX_GLOBAL_PERMISSIONS) {
            if (hashMultimap.containsKey((Object)permission)) {
                for (String string : set) {
                    if (!permission.isApplicableTo(JcrPathHelper.getIdFromAbsolutePath(string))) continue;
                    map.get(string).putAll((Object)permission, (Iterable)hashMultimap.get((Object)permission));
                }
            }
            hashMultimap.removeAll((Object)permission);
        }
    }

    private void addImportRemoveToApplications(Map<String, HashMultimap<Permission, String>> map) {
        logger.info("Adding import#remove to Applications with repo#edit");
        Set set = Sets.filter(map.entrySet(), (Predicate)new Predicate<Map.Entry<String, HashMultimap<Permission, String>>>(){

            public boolean apply(Map.Entry<String, HashMultimap<Permission, String>> entry) {
                boolean bl = JcrPathHelper.getIdFromAbsolutePath(entry.getKey()).startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName());
                boolean bl2 = entry.getValue().containsKey((Object)Permission.EDIT_REPO);
                return bl && bl2;
            }
        });
        for (Map.Entry entry : set) {
            HashSet hashSet = Sets.newHashSet((Iterable)((HashMultimap)entry.getValue()).get((Object)Permission.EDIT_REPO));
            logger.debug("Add import#remove to [{}] for principals [{}]", entry.getKey(), (Object)hashSet);
            ((HashMultimap)entry.getValue()).putAll((Object)Permission.IMPORT_REMOVE, (Iterable)hashSet);
        }
    }

    private void clearAllAcls(Map<String, ListMultimap<Permission, String>> map, RawRepository rawRepository) throws RepositoryException {
        logger.info("Clearing out old permissions!");
        for (Map.Entry<String, ListMultimap<Permission, String>> entry : map.entrySet()) {
            String string = entry.getKey();
            ListMultimap<Permission, String> listMultimap = entry.getValue();
            if (string.equals(GLOBAL)) continue;
            this.clearNodeAcl(rawRepository, string, listMultimap);
        }
        Deployit37Security.clearRoots(rawRepository);
        Deployit37Security.clearAcl("/tasks", Deployit37Security.getAccessControlManager(rawRepository));
        Deployit37Security.clearAcl("/$configuration", Deployit37Security.getAccessControlManager(rawRepository));
        Deployit37Security.clearRepositoryRoot(rawRepository);
    }

    private void clearNodeAcl(RawRepository rawRepository, String string, ListMultimap<Permission, String> listMultimap) throws RepositoryException {
        Deployit37Security.clearAcl(string, Deployit37Security.getAccessControlManager(rawRepository));
        for (Permission permission : listMultimap.keySet()) {
            if (!Deployit37Security.hasRelatedAcls(permission)) continue;
            this.clearRelatedAcls(string, rawRepository);
        }
    }

    private void clearRelatedAcls(String string, RawRepository rawRepository) throws RepositoryException {
        String string2;
        logger.info("Clearing related ACL from [{}]", (Object)string);
        Preconditions.checkArgument((boolean)string.contains(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), (String)"Only environments have a related ACL (%s)", (Object[])new Object[]{string});
        Node node = rawRepository.read(string);
        List list = Lists.newArrayList();
        List list2 = Lists.newArrayList();
        if (node.hasProperty("members")) {
            list = Lists.transform((List)Lists.newArrayList((Object[])node.getProperty("members").getValues()), VALUE_TO_STRING);
        }
        if (node.hasProperty("dictionaries")) {
            list2 = Lists.transform((List)Lists.newArrayList((Object[])node.getProperty("dictionaries").getValues()), VALUE_TO_STRING);
        }
        for (String string3 : list) {
            string2 = ((RawRepositoryImpl)rawRepository).getSession().getNodeByIdentifier(string3).getPath();
            logger.debug("Clearing ACL from member [{}] of environment [{}]", (Object)string2, (Object)string);
            Deployit37Security.clearAcl(string2, Deployit37Security.getAccessControlManager(rawRepository));
        }
        for (String string3 : list2) {
            string2 = ((RawRepositoryImpl)rawRepository).getSession().getNodeByIdentifier(string3).getPath();
            logger.debug("Clearing ACL from dictionary [{}] of environment [{}]", (Object)string2, (Object)string);
            Deployit37Security.clearAcl(string2, Deployit37Security.getAccessControlManager(rawRepository));
        }
    }

    private void createNewRepositoryStructure(Map<String, String> map, RawRepository rawRepository) throws RepositoryException {
        Object object;
        logger.info("Creating the new Repository structure.");
        String string = Type.valueOf(Directory.class).toString();
        for (String object2 : Sets.newHashSet(map.values())) {
            object = rawRepository.create(object2);
            if (object.getIndex() != 1) {
                object.remove();
                throw new IllegalStateException("The impossible has happened, you already have a node called [" + object2 + "] in your repository. Please contact deployit-support@xebialabs.com");
            }
            object.addMixin("deployit:configurationItem");
            object.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            object.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
            object.setProperty("$configuration.item.type", string);
            logger.debug("Created a [{}] at [{}]", (Object)string, (Object)object2);
        }
        for (Map.Entry entry : map.entrySet()) {
            object = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = PATH_JOINER.join((Object)string2, Iterables.getLast((Iterable)PATH_SPLITTER.split((CharSequence)object)), new Object[0]);
            logger.debug("Moving [{}] to new location [{}]", object, (Object)string3);
            ((RawRepositoryImpl)rawRepository).getSession().move((String)object, string3);
        }
    }

    private void writeNewPermissions(Map<String, HashMultimap<Permission, String>> map, List<Role> list, RawRepository rawRepository, Node node) throws RepositoryException {
        logger.info("Writing the new permissions!");
        for (Map.Entry<String, HashMultimap<Permission, String>> entry : map.entrySet()) {
            if (entry.getKey().equals(GLOBAL)) {
                logger.info("Writing global permissions.");
                this.writeNewPermissions(entry.getValue(), list, node);
                continue;
            }
            this.writeNewNodePermissions(entry.getKey(), entry.getValue(), list, rawRepository);
        }
    }

    private void writeNewNodePermissions(String string, HashMultimap<Permission, String> hashMultimap, List<Role> list, RawRepository rawRepository) throws RepositoryException {
        logger.info("Writing new permissions for node [{}]", (Object)string);
        Node node = rawRepository.read(string);
        this.writeNewPermissions(hashMultimap, list, node);
    }

    private void writeNewPermissions(HashMultimap<Permission, String> hashMultimap, List<Role> list, Node node) throws RepositoryException {
        final ImmutableMap immutableMap = Maps.uniqueIndex(list, (Function)new Function<Role, String>(){

            public String apply(Role role) {
                return role.getName();
            }
        });
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : hashMultimap.asMap().entrySet()) {
            hashMap.put(((Permission)((Object)entry.getKey())).getPermissionName(), PRINCIPAL_JOINER.join(Iterables.transform((Iterable)((Iterable)entry.getValue()), (Function)new Function<String, Integer>(){

                public Integer apply(String string) {
                    Role role = (Role)immutableMap.get((Object)string);
                    return role.getId();
                }
            })));
        }
        JcrUtils.writeMap(node, "securityPermissions", hashMap);
    }

    private void writeRoleAssignments(List<Role> list, RawRepository rawRepository) throws RepositoryException {
        logger.info("Writing initial role assignments");
        Node node = rawRepository.create("/$configuration/roleAssignments");
        for (Role role : list) {
            node.setProperty(role.getName(), role.getId().toString());
        }
    }

    private List<Role> convertToRoles(Set<String> set) {
        logger.info("Converting all principals to roles");
        final AtomicInteger atomicInteger = new AtomicInteger(1);
        return Lists.newArrayList((Iterable)Iterables.transform(set, (Function)new Function<String, Role>(){

            public Role apply(String string) {
                Role role = new Role(atomicInteger.getAndIncrement(), string);
                logger.debug("Giving principal [{}] role id [{}]", (Object)string, (Object)role.getId());
                return role;
            }
        }));
    }

    private void writeRoles(List<Role> list, RawRepository rawRepository) throws RepositoryException {
        logger.info("Writing new Roles");
        Node node = rawRepository.create("/$configuration/roles");
        for (Role role : list) {
            node.setProperty(role.getId().toString(), role.getName());
        }
    }

    private Set<String> gatherAllKnownPrincipals(Map<String, HashMultimap<Permission, String>> map) throws RepositoryException {
        logger.info("Extracting all known principals");
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry<String, HashMultimap<Permission, String>> entry : map.entrySet()) {
            logger.info("Extracting known principals from [{}]", (Object)entry.getKey());
            HashMultimap<Permission, String> hashMultimap = entry.getValue();
            Collection collection = hashMultimap.asMap().values();
            for (Collection collection2 : collection) {
                hashSet.addAll(collection2);
            }
        }
        return hashSet;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.0");
    }

    private static boolean hasRelatedAcls(Permission permission) {
        return RELATED_ACL_PERMISSIONS.contains((Object)permission);
    }

    private static List<Tuple<Permission, String>> transformValuesToPermissions(Property property) throws RepositoryException {
        Object[] objectArray = property.getValues();
        return Lists.transform((List)Lists.newArrayList((Object[])objectArray), (Function)new Function<Value, Tuple<Permission, String>>(){

            public Tuple<Permission, String> apply(Value value) {
                try {
                    return Deployit37Security.decodePermissionString(value.getString());
                }
                catch (RepositoryException repositoryException) {
                    logger.error("Exception while migrating security: ", (Throwable)repositoryException);
                    throw new UpgradeException("Please read the server log to see what went wrong with migration of security.", new Object[0]);
                }
            }
        });
    }

    private static Tuple<Permission, String> decodePermissionString(String string) {
        for (Permission permission : Permission.values()) {
            if (!string.startsWith(permission.getPermissionName())) continue;
            return Deployit37Security.decodePermissionString(string, permission);
        }
        throw new RuntimeException("PermissionString " + string + " could not be decoded");
    }

    private static Tuple<Permission, String> decodePermissionString(String string, Permission permission) {
        int n = permission.getPermissionName().length() + 1;
        if (n >= string.length()) {
            return new Tuple<Permission, String>(permission, GLOBAL);
        }
        String string2 = string.substring(n).replace("$", "/");
        return new Tuple<Permission, String>(permission, string2);
    }

    private static void copyPermissions(Multimap<Permission, String> multimap, Multimap<Permission, String> multimap2, Permission permission) {
        if (multimap.containsKey((Object)permission)) {
            multimap2.putAll((Object)permission, (Iterable)multimap.get((Object)permission));
        }
    }

    private static AccessControlManager getAccessControlManager(RawRepository rawRepository) throws RepositoryException {
        Session session = ((RawRepositoryImpl)rawRepository).getSession();
        return session.getAccessControlManager();
    }

    private static void clearAcl(String string, AccessControlManager accessControlManager) throws RepositoryException {
        AccessControlPolicy[] accessControlPolicyArray;
        logger.info("Clearing ACL from [{}]", (Object)string);
        for (AccessControlPolicy accessControlPolicy : accessControlPolicyArray = accessControlManager.getPolicies(string)) {
            if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList jackrabbitAccessControlList = (JackrabbitAccessControlList)accessControlPolicy;
            for (AccessControlEntry accessControlEntry : jackrabbitAccessControlList.getAccessControlEntries()) {
                jackrabbitAccessControlList.removeAccessControlEntry(accessControlEntry);
            }
            accessControlManager.setPolicy(string, accessControlPolicy);
        }
    }

    private static void clearRoots(RawRepository rawRepository) throws RepositoryException {
        logger.info("Clearing ACL on Root nodes.");
        for (Metadata.ConfigurationItemRoot configurationItemRoot : EnumSet.complementOf(EnumSet.of(Metadata.ConfigurationItemRoot.NESTED))) {
            String string = JcrPathHelper.getAbsolutePathFromId(configurationItemRoot.getRootNodeName());
            Deployit37Security.clearAcl(string, Deployit37Security.getAccessControlManager(rawRepository));
        }
    }

    private static void clearRepositoryRoot(RawRepository rawRepository) throws RepositoryException {
        logger.info("Clearing the repository root...");
        Deployit37Security.clearAcl("/", Deployit37Security.getAccessControlManager(rawRepository));
        Deployit37Security.grantEveryoneReadAccess("/", Deployit37Security.getAccessControlManager(rawRepository));
    }

    private static void grantEveryoneReadAccess(String string, AccessControlManager accessControlManager) throws RepositoryException {
        for (AccessControlPolicy accessControlPolicy : accessControlManager.getPolicies(string)) {
            if (!(accessControlPolicy instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList jackrabbitAccessControlList = (JackrabbitAccessControlList)accessControlPolicy;
            Privilege privilege = accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            jackrabbitAccessControlList.addAccessControlEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{privilege});
            accessControlManager.setPolicy("/", accessControlPolicy);
        }
    }
}

