/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDir
implements Serializable {
    private AtomicInteger uniqueDir = new AtomicInteger(0);
    private final LocalFile workDir;
    private static final Logger logger = LoggerFactory.getLogger(WorkDir.class);

    public WorkDir(LocalFile localFile) {
        this.workDir = localFile;
    }

    public LocalFile newFile(String string) {
        Preconditions.checkState((boolean)this.workDir.exists(), (String)"Cannot create a new file when workDir [%s] does not exist.", (Object[])new Object[]{this.workDir});
        return this.newUniqueFile(string);
    }

    private LocalFile newUniqueFile(String string) {
        OverthereFile overthereFile = this.workDir.getFile("artifact-" + this.uniqueDir.getAndIncrement());
        Preconditions.checkState((!overthereFile.exists() ? 1 : 0) != 0, (String)"The unique artifact dir [%s] should not exist yet", (Object[])new Object[]{overthereFile.getPath()});
        overthereFile.mkdir();
        return (LocalFile)overthereFile.getFile(string);
    }

    public String getPath() {
        return this.workDir.getPath();
    }

    public void delete() {
        logger.debug("Deleting workDir {}", (Object)this);
        if (this.workDir.exists()) {
            this.workDir.deleteRecursively();
            Preconditions.checkState((!this.workDir.exists() ? 1 : 0) != 0, (String)"Workdirectory %s should have been deleted.", (Object[])new Object[]{this});
        } else {
            logger.warn("Workdirectory {} already deleted.", (Object)this);
        }
    }

    public String toString() {
        return "WorkDir[" + this.getPath() + "]";
    }
}

