/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class LoginPermissionVoter
implements AccessDecisionVoter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> collection) {
        logger.debug("Checking authorization for [{}]", (Object)authentication.getName());
        if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, Permission.LOGIN)) {
            logger.debug("User [{}] is authorized for login", (Object)authentication.getName());
            return 1;
        }
        logger.error("User [{}] is not allowed to login to Deployit.", (Object)authentication.getName());
        return -1;
    }
}

