/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionLister {
    private final JcrTemplate jcrTemplate;
    private final RepositoryService repositoryService;

    @Autowired
    public PermissionLister(JcrTemplate jcrTemplate, RepositoryService repositoryService) {
        this.jcrTemplate = jcrTemplate;
        this.repositoryService = repositoryService;
    }

    public Multimap<String, String> listPermissions(Role role) {
        return this.listPermissions(Lists.newArrayList((Object[])new Role[]{role}));
    }

    public Multimap<String, String> listPermissions(final List<Role> list) {
        final HashMultimap hashMultimap = HashMultimap.create();
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                PermissionLister.this.readGlobalPermissions(session, (HashMultimap<String, String>)hashMultimap, list);
                PermissionLister.this.readCiLevelPermissions(session, (HashMultimap<String, String>)hashMultimap, list);
                return null;
            }
        });
        return hashMultimap;
    }

    private void readCiLevelPermissions(Session session, HashMultimap<String, String> hashMultimap, List<Role> list) throws RepositoryException {
        List<ConfigurationItemData> list2 = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Directory.class)));
        List<ConfigurationItemData> list3 = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Root.class)));
        for (ConfigurationItemData configurationItemData : Iterables.concat(list2, list3)) {
            Node node = Permissions.readSecurable(configurationItemData.getId(), session);
            this.readPermissionsFromNode(hashMultimap, list, configurationItemData.getId(), node);
        }
    }

    private void readPermissionsFromNode(HashMultimap<String, String> hashMultimap, final List<Role> list, String string, Node node) throws RepositoryException {
        Map<String, String> map = Permissions.readPermissionMap(node);
        hashMultimap.putAll((Object)string, (Iterable)Collections2.transform((Collection)Sets.filter(map.entrySet(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> entry) {
                return PermissionLister.this.checkAllowed(entry.getValue(), list);
            }
        }), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> entry) {
                return entry.getKey();
            }
        }));
    }

    private void readGlobalPermissions(Session session, HashMultimap<String, String> hashMultimap, List<Role> list) throws RepositoryException {
        Node node = session.getNode("/$configuration/security");
        this.readPermissionsFromNode(hashMultimap, list, "", node);
    }

    private boolean checkAllowed(String string, List<Role> list) {
        Iterable<Integer> iterable = Permissions.splitRoles(string);
        return Iterables.any(iterable, (Predicate)Predicates.in((Collection)Lists.newArrayList(Permissions.rolesToIds(list))));
    }
}

