/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.security.SecurityUtils;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class RememberMe {
    private static final ConcurrentMap<String, Authentication> AUTH_CACHE = new MapMaker().expireAfterAccess(10L, TimeUnit.MINUTES).makeMap();
    private static final Logger logger = LoggerFactory.getLogger(RememberMe.class);

    public static void remember(Authentication authentication) {
        String string = RememberMe.createKey(authentication);
        logger.debug("Remembering authentication token for [{}]", (Object)authentication.getName());
        AUTH_CACHE.put(string, authentication);
    }

    public static void forget(Authentication authentication) {
        String string = RememberMe.createKey(authentication);
        if (AUTH_CACHE.containsKey(string)) {
            AUTH_CACHE.remove(string);
        } else {
            logger.info("Couldn't forget authentication for [{}] because it was not remembered.", (Object)authentication.getName());
        }
    }

    public static Authentication getRemembered(String string, String string2) {
        String string3 = RememberMe.encodeUserPassword(string, string2);
        if (AUTH_CACHE.containsKey(string3)) {
            return (Authentication)AUTH_CACHE.get(string3);
        }
        logger.debug("Token for [{}] not yet remembered.", (Object)string);
        return null;
    }

    public static void forgetMe() {
        RememberMe.forget(SecurityUtils.getAuthentication());
    }

    private static String createKey(Authentication authentication) {
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (UsernamePasswordAuthenticationToken)authentication;
            String string = usernamePasswordAuthenticationToken.getName();
            String string2 = usernamePasswordAuthenticationToken.getCredentials().toString();
            return RememberMe.encodeUserPassword(string, string2);
        }
        throw new IllegalArgumentException("The authentication should always be a UsernamePasswordAuthenticationToken");
    }

    private static String encodeUserPassword(String string, String string2) {
        return new String(new Base64Coder().encode((string + ":" + string2).getBytes()), Charset.defaultCharset());
    }
}

