/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.planning.PostPlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DeploymentPlannerFactory {
    public static final Comparator<Method> PROCESSOR_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method method, Method method2) {
            int n;
            int n2;
            String string = method.getDeclaringClass().getSimpleName();
            String string2 = method2.getDeclaringClass().getSimpleName();
            if (method.isAnnotationPresent(PrePlanProcessor.class)) {
                n2 = method.getAnnotation(PrePlanProcessor.class).order();
                n = method2.getAnnotation(PrePlanProcessor.class).order();
            } else {
                n2 = method.getAnnotation(PostPlanProcessor.class).order();
                n = method2.getAnnotation(PostPlanProcessor.class).order();
            }
            if (n2 != n) {
                return Integer.valueOf(n2).compareTo(n);
            }
            if (!string.equals(string2)) {
                return string.compareTo(string2);
            }
            return method.getName().compareTo(method2.getName());
        }
    };

    public DeploymentPlanner planner(ReadOnlyRepository readOnlyRepository) {
        ListMultimap<Operation, Method> listMultimap = this.registerDeployedContributors();
        Set<Method> set = this.registerContributors();
        List<Method> list = this.orderProcessors(this.checkProcessors(ReflectionsHolder.getMethodsAnnotatedWith(PrePlanProcessor.class)));
        List<Method> list2 = this.orderProcessors(this.checkProcessors(ReflectionsHolder.getMethodsAnnotatedWith(PostPlanProcessor.class)));
        return new DeploymentPlanner.DeploymentPlannerBuilder().preProcessors(list).postProcessors(list2).typeContributors(listMultimap).contributors(set).repository(readOnlyRepository).build();
    }

    private List<Method> orderProcessors(Set<Method> set) {
        ArrayList arrayList = Lists.newArrayList(set);
        Collections.sort(arrayList, PROCESSOR_COMPARATOR);
        return arrayList;
    }

    private ListMultimap<Operation, Method> registerDeployedContributors() {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        this.registerDeployedContributors(Create.class, Operation.CREATE, (ListMultimap<Operation, Method>)arrayListMultimap);
        this.registerDeployedContributors(Modify.class, Operation.MODIFY, (ListMultimap<Operation, Method>)arrayListMultimap);
        this.registerDeployedContributors(Destroy.class, Operation.DESTROY, (ListMultimap<Operation, Method>)arrayListMultimap);
        this.registerDeployedContributors(Noop.class, Operation.NOOP, (ListMultimap<Operation, Method>)arrayListMultimap);
        return arrayListMultimap;
    }

    private void registerDeployedContributors(Class<? extends Annotation> clazz, Operation operation, ListMultimap<Operation, Method> listMultimap) {
        TreeSet<Method> treeSet = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        treeSet.addAll(this.checkDeployedContributors(ReflectionsHolder.getMethodsAnnotatedWith(clazz)));
        for (Method method : treeSet) {
            listMultimap.put((Object)operation, (Object)method);
        }
    }

    private Set<Method> registerContributors() {
        TreeSet<Method> treeSet = new TreeSet<Method>(new HierarchyClassMethodNameComparator());
        treeSet.addAll(this.checkContributors(ReflectionsHolder.getMethodsAnnotatedWith(Contributor.class)));
        return treeSet;
    }

    private Set<Method> checkDeployedContributors(Set<Method> set) {
        for (Method method : set) {
            Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"DeployedContributor %s should have void return type.", (Object[])new Object[]{method});
            Class<?>[] classArray = method.getParameterTypes();
            Preconditions.checkArgument((classArray.length <= 2 && classArray.length >= 1 ? 1 : 0) != 0, (String)"DeployedContributor %s should take 1 or 2 parameters.", (Object[])new Object[]{method});
            Preconditions.checkArgument((boolean)classArray[0].equals(DeploymentPlanningContext.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{method, DeploymentPlanningContext.class});
            if (classArray.length != 2) continue;
            Preconditions.checkArgument((boolean)classArray[1].equals(Delta.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{method, Delta.class});
        }
        return set;
    }

    private Set<Method> checkContributors(Set<Method> set) {
        for (Method method : set) {
            Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"Contributor %s should have void return type.", (Object[])new Object[]{method});
            Class<?>[] classArray = method.getParameterTypes();
            Preconditions.checkArgument((classArray.length == 2 ? 1 : 0) != 0, (String)"Contributor %s should take 2 parameters.", (Object[])new Object[]{method});
            Preconditions.checkArgument((boolean)classArray[0].equals(Deltas.class), (String)"Contributor %s should take %s as first parameter.", (Object[])new Object[]{method, Deltas.class});
            Preconditions.checkArgument((boolean)classArray[1].equals(DeploymentPlanningContext.class), (String)"Contributor %s should take %s as second parameter.", (Object[])new Object[]{method, DeploymentPlanningContext.class});
        }
        return set;
    }

    private Set<Method> checkProcessors(Set<Method> set) {
        for (Method method : set) {
            Preconditions.checkArgument((method.getReturnType().equals(Step.class) || method.getReturnType().equals(List.class) ? 1 : 0) != 0, (String)"Pre/Post processor %s should have a Step or List<Step> return type.", (Object[])new Object[]{method});
            Class<?>[] classArray = method.getParameterTypes();
            Preconditions.checkArgument((classArray.length == 1 ? 1 : 0) != 0, (String)"Processor %s should take 1 parameter.", (Object[])new Object[]{method});
            Preconditions.checkArgument((boolean)classArray[0].equals(DeltaSpecification.class), (String)"Processor %s should take %s as first parameter.", (Object[])new Object[]{method, DeltaSpecification.class});
        }
        return set;
    }

    public static class HierarchyClassMethodNameComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method method, Method method2) {
            String string;
            Class<?> clazz;
            Class<?> clazz2 = method.getDeclaringClass();
            if (this.isSuperClass(clazz2, clazz = method2.getDeclaringClass())) {
                return -1;
            }
            if (this.isSuperClass(clazz, clazz2)) {
                return 1;
            }
            String string2 = clazz2.getName();
            int n = string2.compareTo(string = clazz.getName());
            if (n == 0) {
                return method.getName().compareTo(method2.getName());
            }
            return n;
        }

        boolean isSuperClass(Class<?> clazz, Class<?> clazz2) {
            return clazz.isAssignableFrom(clazz2) && !clazz.getName().equals(clazz2.getName());
        }
    }
}

