/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.CifsFile;
import com.xebialabs.overthere.cifs.PathEncoder;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CifsConnection
extends BaseOverthereConnection {
    protected CifsConnectionType cifsConnectionType;
    protected String address;
    protected int cifsPort;
    protected int port;
    protected String username;
    protected String password;
    protected PathEncoder encoder;
    protected NtlmPasswordAuthentication authentication;
    private static Logger logger = LoggerFactory.getLogger(CifsConnection.class);

    public CifsConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper, boolean bl) {
        super(string, connectionOptions, addressPortMapper, bl);
        this.cifsConnectionType = (CifsConnectionType)((Object)connectionOptions.get("connectionType"));
        String string2 = (String)connectionOptions.get("address");
        InetSocketAddress inetSocketAddress = addressPortMapper.map(InetSocketAddress.createUnresolved(string2, connectionOptions.get("port", this.getDefaultPort())));
        this.address = inetSocketAddress.getHostName();
        this.port = inetSocketAddress.getPort();
        this.username = (String)connectionOptions.get("username");
        this.password = (String)connectionOptions.get("password");
        InetSocketAddress inetSocketAddress2 = addressPortMapper.map(InetSocketAddress.createUnresolved(string2, connectionOptions.get("cifsPort", 445)));
        this.cifsPort = inetSocketAddress2.getPort();
        this.encoder = new PathEncoder(null, null, this.address, this.cifsPort, connectionOptions.get("pathShareMappings", CifsConnectionBuilder.PATH_SHARE_MAPPINGS_DEFAULT));
        this.authentication = new NtlmPasswordAuthentication(null, this.username, this.password);
    }

    private Integer getDefaultPort() {
        switch (this.cifsConnectionType) {
            case TELNET: {
                return 23;
            }
            case WINRM_HTTP: {
                return 5985;
            }
            case WINRM_HTTPS: {
                return 5986;
            }
        }
        throw new IllegalArgumentException("Unknown CIFS connection type " + (Object)((Object)this.cifsConnectionType));
    }

    @Override
    public void doClose() {
    }

    @Override
    public OverthereFile getFile(String string) throws RuntimeIOException {
        try {
            SmbFile smbFile = new SmbFile(this.encodeAsSmbUrl(string), this.authentication);
            return new CifsFile(this, smbFile);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public OverthereFile getFile(OverthereFile overthereFile, String string) throws RuntimeIOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(overthereFile.getPath());
        if (!overthereFile.getPath().endsWith(this.getHostOperatingSystem().getFileSeparator())) {
            stringBuilder.append(this.getHostOperatingSystem().getFileSeparator());
        }
        stringBuilder.append(string.replace('\\', '/'));
        return this.getFile(stringBuilder.toString());
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile overthereFile, String string) {
        return this.getFile(overthereFile, string);
    }

    private String encodeAsSmbUrl(String string) {
        try {
            String string2 = this.encoder.toSmbUrl(string);
            logger.trace("Encoded Windows host path {} to SMB URL {}", (Object)string, (Object)this.maskSmbUrl(string2));
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeIOException(illegalArgumentException);
        }
    }

    private String maskSmbUrl(String string) {
        return string.replace(this.password, "********");
    }

    @Override
    public String toString() {
        return "cifs:" + this.cifsConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.address + ":" + this.cifsPort + ":" + this.port;
    }
}

