/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.telnet.CifsTelnetConnection;
import com.xebialabs.overthere.cifs.winrm.CifsWinRmConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import java.util.Map;

@Protocol(name="cifs")
public class CifsConnectionBuilder
implements OverthereConnectionBuilder {
    public static final String CIFS_PROTOCOL = "cifs";
    public static final String CONNECTION_TYPE = "connectionType";
    public static final int DEFAULT_TELNET_PORT = 23;
    public static final int DEFAULT_WINRM_HTTP_PORT = 5985;
    public static final int DEFAULT_WINRM_HTTPS_PORT = 5986;
    public static final String CIFS_PORT = "cifsPort";
    public static final int DEFAULT_CIFS_PORT = 445;
    public static final String PATH_SHARE_MAPPINGS = "pathShareMappings";
    public static final Map<String, String> PATH_SHARE_MAPPINGS_DEFAULT = ImmutableMap.of();
    public static final String CONTEXT = "winrmContext";
    public static final String DEFAULT_WINRM_CONTEXT = "/wsman";
    public static final String TIMEMOUT = "winrmTimeout";
    public static final String DEFAULT_TIMEOUT = "PT60.000S";
    public static final String ENVELOP_SIZE = "winrmEnvelopSize";
    public static final int DEFAULT_ENVELOP_SIZE = 153600;
    public static final String LOCALE = "winrmLocale";
    public static final String DEFAULT_LOCALE = "en-US";
    private OverthereConnection connection;

    public CifsConnectionBuilder(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        CifsConnectionType cifsConnectionType = (CifsConnectionType)((Object)connectionOptions.get(CONNECTION_TYPE));
        switch (cifsConnectionType) {
            case TELNET: {
                this.connection = new CifsTelnetConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            case WINRM_HTTP: 
            case WINRM_HTTPS: {
                this.connection = new CifsWinRmConnection(string, connectionOptions, addressPortMapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CIFS connection type " + (Object)((Object)cifsConnectionType));
            }
        }
    }

    @Override
    public OverthereConnection connect() {
        return this.connection;
    }

    public String toString() {
        return ((Object)this.connection).toString();
    }
}

